/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.peace.security;

import com.beiming.framework.security.JWTSecurityConfig;
import java.util.Arrays;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.EnableWebSecurity;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;

@EnableWebSecurity
public class WebSecurityConfig
extends JWTSecurityConfig {
    @Value(value="${jwt.auth.secret}")
    private String authJwtSecret;
    @Value(value="${spring.security.allowCorsOrigin}")
    private String allowCorsOrigin;

    @Bean
    CorsConfigurationSource corsConfigurationSource() {
        CorsConfiguration configuration = new CorsConfiguration();
        configuration.setAllowedOrigins(Arrays.asList(this.allowCorsOrigin));
        configuration.setAllowedMethods(Arrays.asList("*"));
        configuration.setAllowedHeaders(Arrays.asList("*"));
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", configuration);
        return source;
    }

    protected String getJWTSecret() {
        return this.authJwtSecret;
    }

    public void configure(WebSecurity web) throws Exception {
        web.ignoring().antMatchers(new String[]{"/peace/user/resetUserPassWord", "/peace/user/userLoginByMobile", "/peace/user/userLoginByMobileNew", "/peace/user/validateCertGenRandom", "/peace/user/userLoginByCert", "/peace/user/oauth/token", "/peace/user/api/v1/internet/unifed/judgeCardId", "/peace/user/api/v1/internet/userInfo/login/loginByCardId", "/peace/user/api/v1/internet/userInfo/getInfo/getUserInfoByToken", "/peace/user/api/v1/internet/userInfo/getInfo/getUserInfoByToken", "/peace/user/getSMSCode", "/peace/user/refreshToken", "/peace/user/getPublicKey", "/peace/user/userLoginByCode", "/peace/user/userLoginByCodeNew", "/peace/user/userLoginByBindingWechat", "/peace/user/userLoginByWechat", "/peace/user/checkValidCode", "/peace/user/userLoginByMobileTwo", "/peace/user/staffLoginByPhone", "/peace/user/userLoginByAppId", "/peace/user/userIdCard", "/peace/clerkOpinion/clerkConfirm", "/peace/user/getWechatMobilePhoneByCode", "/peace/area/**", "/resources/peace/sign/jump/**", "/peace/user/allInOneUserInfo", "/peace/user/allInOneLogin", "/peace/sign/jump/**", "/peace/signature/**", "/peace/user/userLoginByMicroCourt", "/peace/user/userLoginBySxMicroCourt", "/peace/preview/createMeeting", "/peace/preview/mediatorLogin", "/peace/preview/userLogin/**", "/peace/wuhu/createMeeting", "/peace/wuhu/mediatorLogin", "/peace/wuhu/userLogin/**", "/resources/peace/preview/userLogin/**", "/peace/caseCause/likeAll", "/peace/thirdParty/readyForCourtById", "/peace/thirdParty/getRtcInfo", "/peace/thirdParty/getLitigantRtcInfo", "/peace/thirdParty/getMemberInfo", "/peace/thirdParty/getUserId", "/peace/thirdParty/getLitigantInfo", "/peace/dictionary/searchOperationVideo", "/peace/intranet/**", "/peace/personal/getSchemeCode", "/peace/test/getSchemeCode", "/peace/thirdParty/token", "/peace/mediationRoomMicro/pushMediationRoomMicro", "/peace/visitorSystem/setRealNameAndFacialVerify", "/peace/visitorSystem/refreshToken", "/peace/visitorSystem/judgeLogin", "/peace/user/verifyService", "/peace/file/downloadMaterials", "/peace/create/push", "/peace/thirdParty/obtainCertificate", "/peace/thirdParty/obtainCertificateWeChat", "/peace/test/getCode", "/peace/thirdParty/pendScheduleCaseNum", "/peace/hainanSm4/exDataEncrypt", "/peace/hainanSm4/sm4Encrypt", "/peace/hainanSm4/sm4Decrypt", "/peace/hainanSm4/macEncrypt", "/peace/hainanSm4/macVerify"});
    }

    protected void configure(HttpSecurity http) throws Exception {
        super.configure(http);
        http.csrf().disable();
        http.cors();
        http.antMatcher("/peace/**");
    }
}

