package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.dto.requestdto.CapacityAssessmentTaskListReqDTO;
import com.beiming.odr.user.api.dto.responsedto.ExecutionCapacityAssessmentInitResDTO;

/**
 * 能力评估后台跑批功能
 * @author ljf
 *
 */
public interface CapacityAssessmentTaskApi {
  /**
   * 执行机构管理员能力评估
   */
  DubboResult<PageInfo<String>> executionOrgManageEvaluation(CapacityAssessmentTaskListReqDTO req);
  /**
   * 执行机构/调解员能力评估
   */
  DubboResult<PageInfo<String>> executionEvaluation(CapacityAssessmentTaskListReqDTO req);
  /**
   * 能力评估完成需要将数据转移到目标表
   * @param req
   * @return
   */
  DubboResult executionEvaluationComplete(CapacityAssessmentTaskListReqDTO req);
  /**
   * 执行初始化语句初始化机构评估数据
   * 响应机构的数量
   * @return
   */
  DubboResult<ExecutionCapacityAssessmentInitResDTO> executionOrgInitData();
  /**
   * 执行初始化语句初始化机构管理员评估数据
   * 响应机构管理员的数量
   * @return
   */
  DubboResult<ExecutionCapacityAssessmentInitResDTO> executionOrgManageInitData();
  /**
   * 执行初始化语句初始化调解员评估数据
   * 响应需要调解员的数量
   * @return
   */
  DubboResult<ExecutionCapacityAssessmentInitResDTO> executionMediationInitData();
}
