package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.user.api.auth.dto.responsedto.*;
import com.beiming.odr.user.api.dto.responsedto.LoginInfoResDTO;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public interface DataStatisticsCourtApi {

  DubboResult<CourtInfoResDTO> findCourtById(String id);

  DubboResult<ArrayList<CourtInfoResDTO>> findCourtsByParentId(String parentId);

  DubboResult<ArrayList<CourtInfoResDTO>> findCourtsByParentIdAndId(String id);

  DubboResult<ArrayList<CourtInfoResDTO>> getCourtsList(Map<String, Object> params);

  DubboResult<ArrayList<JudgeInfoResDTO>> getJudgeInfoList(Map<String, Object> params);

  DubboResult<CourtInfoResDTO> getUserOrgId(Map<String, Object> params);

  DubboResult<LoginInfoResDTO> userLoginInfo(String userId);

  DubboResult<ArrayList<CourtUserNumResDTO>> getCourtUserNum(Map<String, Object> params);

  DubboResult<CourtInfoResDTO> findProvincialCourt(String orgId);

  DubboResult<ArrayList<CourtInfoResDTO>> findProvincialHbAllCourt();


  /**
   * 查询单个机构下的所有部门
   * @param params
   * @return
   */
  DubboResult<ArrayList<DepartResDTO>> getCourtRoomData(Map<String, Object> params);

  DubboResult<ArrayList<CourtRoomPersonResponseDTO>> getCourtRoomPersonData(Map<String, Object> params);

  /**
   * 查询部门下的所有工作人员
   * @param params
   * @return
   */
  DubboResult<ArrayList<StaffResDTO>> listStaffData(Map<String, Object> params);

  DubboResult<ArrayList<CourtInfoResDTO>> findAllCourtsByParentIds(List<String> orgIdList);
}
