package com.beiming.odr.user.api.auth.dto;

import com.beiming.odr.user.api.common.enums.DefaultAuthRoleEnums;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @ClassName AuthUserRoleDTO
 * @Description
 * @Author xiet
 * @DATE 2020/1/9 4:02 PM
 * @VERSION 1.0
 **/
@Data
@NoArgsConstructor
@AllArgsConstructor
public class AuthUserRoleDTO {

  public AuthUserRoleDTO(DefaultAuthRoleEnums defaultAuthRoleEnums) {
    this.defaultAuthRoleEnums = defaultAuthRoleEnums;
  }

  public AuthUserRoleDTO(Long roleId, Long organizationId, String organizationName,
      String areaCode, String areaFullName) {
    this.roleId = roleId;
    this.organizationId = organizationId;
    this.organizationName = organizationName;
    this.areaCode = areaCode;
    this.areaFullName = areaFullName;
  }

  public AuthUserRoleDTO(String roleCode,
      DefaultAuthRoleEnums defaultAuthRoleEnums) {
    if (defaultAuthRoleEnums == null) {
      this.roleCode = roleCode;
    } else {
      this.roleCode = defaultAuthRoleEnums.name();
    }

  }

  /**
   * 角色id
   */
  private Long roleId;

  /**
   * 角色类型枚举
   */
  private DefaultAuthRoleEnums defaultAuthRoleEnums;

  /**
   * 角色类型
   */
  private String roleCode;

  /**
   * 机构id
   */
  private Long organizationId;

  /**
   * 机构name
   */
  private String organizationName;

  /**
   * 所属地区代码
   */
  private String areaCode;

  /**
   * 所属地区代码名称
   */
  private String areaFullName;
}
