package com.beiming.odr.user.api.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.common.enums.UserSexTypeEnum;
import lombok.Data;

/**
 * 新增普通用户
 */
@Data
public class OrdinaryUserAddReqDTO implements Serializable {

  /**
   * 姓名
   */
  @NotBlank(message = "用户姓名不能为空")
  private String userName;


  /**
   * 手机号
   */
  @Pattern(regexp = UserConst.REGEX_MOBILE_EXACT, message = "手机号码格式错误")
  @NotBlank(message = "手机号不能为空")
  private String mobilePhone;

  /**
   * 身份证
   */
  @NotBlank(message = "身份证不能为空")
  @Pattern(regexp = UserConst.REGEX_ID_CARD, message = "身份证格式错误")
  private String idCard;

  /**
   * 性别
   */
  @NotNull(message = "性别不能为空")
  private UserSexTypeEnum sex;

  /**
   * 工作机构
   */
  private String workOrganization;
}
