package com.beiming.odr.user.api.dto.requestdto;

import com.beiming.odr.user.api.common.constants.UserConst;
import java.io.Serializable;
import javax.validation.constraints.Pattern;
import lombok.Data;


/**
 * 工作人员简单新增参数
 */
@Data
public class BackstageUserSimpleAddReqDTO implements Serializable {

  /**
   * 用户姓名
   */
  private String userName;

  /**
   * 手机号
   */
  @Pattern(regexp = UserConst.REGEX_MOBILE_EXACT, message = "手机号码格式错误")
  private String mobilePhone;

  /**
   * 密码
   */
  @Pattern(regexp = UserConst.REGEX_PASSWORD, message = "密码格式错误")
  private String password;
}
