package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.user.api.auth.dto.requestdto.GetStaffUserResDTO;
import com.beiming.odr.user.api.dto.UserInfoDTO;
import java.util.ArrayList;

public interface BackstageUserMicroServiceApi {


  /**
   * 获取工作人员信息，若不存在创建后返回
   * @param dto
   * @return
   */
  DubboResult<UserInfoDTO> getStaffUser(GetStaffUserResDTO dto);
  
  
  /**
   * 获取工作人员信息，若不存在创建后返回
   * @param dto
   * @return
   */
  DubboResult<UserInfoDTO> getStaffUserAnhui(GetStaffUserResDTO dto);

  /**
   *  只改变实名标识的实名认证（不提供身份证号码）
   * @param userId
   * @return
   */
  DubboResult<String> authentication(Long userId);

  /**
   * 根据姓名、手机号和人员类型查询用户信息
   * @param mobilePhone
   * @param userName
   * @param personType
   * @return
   */
  DubboResult<UserInfoDTO> getUserInfo(String mobilePhone, String userName, String personType);

  /**
   * 根据角色获取账号
   * @param orgId
   * @param roleCode
   * @return
   */
  DubboResult<ArrayList<UserInfoDTO>> getAccountByRoleCode(String orgId, String roleCode);
}
