package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.dto.requestdto.BackstageUserAddReqDTO;
import com.beiming.odr.user.api.dto.requestdto.BackstageUserListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.BackstageUserSearchReqDTO;
import com.beiming.odr.user.api.dto.requestdto.BackstageUserSimpleAddReqDTO;
import com.beiming.odr.user.api.dto.requestdto.BackstageUserUpdateIdCardReqDTO;
import com.beiming.odr.user.api.dto.requestdto.BackstageUserUpdateStatusReqDTO;
import com.beiming.odr.user.api.dto.requestdto.DepartReqDTO;
import com.beiming.odr.user.api.dto.requestdto.SaveScavengerLoginUserInfoReqDTO;
import com.beiming.odr.user.api.dto.responsedto.BackstageUserInfoResDTO;
import com.beiming.odr.user.api.dto.responsedto.DepartmentsResponseDTO;
import java.util.ArrayList;

/**
 * 工作人员相关接口
 * 
 * @author fanheshui
 */
public interface BackstageUserServiceApi {
  /**
   * 添加工作人员
   */

  DubboResult<Long> insertBackstageUser(BackstageUserAddReqDTO backstageUserAddReqDTO);

  /**
   * 修改工作人员
   */
  DubboResult updateBackstageUser(BackstageUserAddReqDTO backstageuserAddReqDTO);

  /**
   * 查询工作人员
   */
  DubboResult<BackstageUserInfoResDTO> searchBackstageUser(
      BackstageUserSearchReqDTO backstageUserSearchReqDTO);

  /**
   * 更新工作人员状态-禁用或启用
   */
  DubboResult updateBackstageUserStatus(BackstageUserUpdateStatusReqDTO req);

  /**
   * 删除工作人员
   * @return
   */
  DubboResult deleteBackstageUser(Long userId);

  /**
   * 工作人员列表
   */
  DubboResult<PageInfo<BackstageUserInfoResDTO>> listBackstageUser(
      BackstageUserListReqDTO backstageUserListReqDTO);

  /**
   * 重置默认密码
   */
  DubboResult resetDefaultPassword(Long userId);

  /**
   * 环资项目-更新当前登录用户个人资料
   */
  DubboResult updateScavengerLoginUserInfo(SaveScavengerLoginUserInfoReqDTO req);

  /**
   * 简单添加工作人员，无需角色 详细地址 材料
   */
  DubboResult<Long> insertBackstageUserSimple(
      BackstageUserSimpleAddReqDTO backstageUserSimpleAddReqDTO);

  DubboResult updateBackstageUserIdCard(BackstageUserUpdateIdCardReqDTO res);

  /**
   * 根据机构id获取所有的部门信息数据
   * @param orgId
   * @return
   */
  DubboResult<ArrayList<DepartmentsResponseDTO>> listDepartment(DepartReqDTO orgId);
}
