package com.beiming.odr.user.api.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.NotNull;
import com.beiming.framework.page.PageQuery;
import com.beiming.odr.user.api.common.enums.ApplicableObjectEnums;
import com.beiming.odr.user.api.common.enums.ReqUserTypeEnums;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 评估结果请求DTO
 * 
 * @author ljf
 *
 */
@Data
@EqualsAndHashCode(callSuper = false)
public class CapacityAssessmentListReqDTO extends PageQuery implements Serializable {

  /**
   * 
   */
  private static final long serialVersionUID = -3590843778591326931L;
  @NotNull
  private ReqUserTypeEnums reqUserType;
  @NotNull
  private ApplicableObjectEnums queryType;
  /**
   * 查询者的角色类型（区域管理员还是机构管理员）
   */
  private String userType;
  /**
   * 查询目标数据类型（机构或者是调解员），
   */
  private String qType;

  private String orgId;
  // 模糊查询
  private String userId;

  private String areaCode;
  /**
   * 开始日期
   */
  private String startDate;
  /**
   * 结束日期
   */
  private String endDate;

  /**
   * ReqUserTypeEnums.AREA_MANAGER 0 ReqUserTypeEnums.ORG_MANAGER 1
   * 
   * @return the
   */
  public String getUserType() {
    return reqUserType.toString();
  }

  public String getqType() {
    return queryType.toString();
  }

  
}
