package com.beiming.odr.user.api.dto.requestdto;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import com.beiming.framework.page.PageQuery;
import lombok.Data;

@Data
public class ServicePersonListReqDTO extends PageQuery implements Serializable {
  
  /**
   * appName
   */
  private String appName;
  /**
   * 人员名称
   */
  private String userName;
  /**
   * 人员名称-精确查询
   */
  private String fullUserName;
  
  /**
   * 机构id
   */
  private Long orgId;
  
  /**
   * 机构id集合
   */
  private List<Long> orgIds;
  
  /**
   * 机构类型集合
   */
  private List<String> orgTypeCodes;
  
  /**
   * 需排除的机构类型集合
   */
  private List<String> excludeOrgTypeCodes;
  
  /**
   * 擅长领域
   */
  private String ability;
  
  /**
   * 调解方式
   */
  private String mediateCode;
  
  /**
   * 人员类型（调解员、咨询师、法官）
   */
  private String roleType;
  private String roleCode;

  /**
   * 区域代码
   */
  private String areaCode;
  
  /**
   * 服务区域代码前两位（匹配省）
   */
  private String serviceAreaCodeTwo;
  
  /**
   * 服务区域代码前四位（匹配市）
   */
  private String serviceAreaCodeFour;
  
  /**
   * 服务区域代码前六位（匹配区）
   */
  private String serviceAreaCodeSix;

  /**
   * 服务区域代码前九位（匹配街道）
   */
  private String serviceAreaCodeNine;
  /**
   * 服务区域代码十二位（匹配社区）
   */
  private String serviceAreaCodeTwelve;
  
  /**
   * 当前登录用户id
   */
  private String currentUserId;

  /**
   * 备注
   */
  private String remark;
  
  /**
   * 关键字（用户名称或擅长领域）
   */
  private String keywords;
  
  /**
   * 需排除的调解员id
   */
  private List<Long> excludeUserIds;
  
  /**
   * 列表类型 协助调解员列表 服务资源列表
   */
  private String listType;

  /**
   * 人员类型。特定用于区别法官，调解员，法官助理
   * */
  private String curManFilterType;

  /**
   * 创建时间
   */
  private Date createTime;
  
}
