package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.common.enums.StatusEnum;
import com.beiming.odr.user.api.dto.requestdto.BackstageOrganizationAddReqDTO;
import com.beiming.odr.user.api.dto.requestdto.BackstageOrganizationListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.BackstageOrganizationSearchReqDTO;
import com.beiming.odr.user.api.dto.requestdto.BackstageOrganizationUpdateReqDTO;
import com.beiming.odr.user.api.dto.requestdto.SaasOrgRequestDTO;
import com.beiming.odr.user.api.dto.responsedto.BackstageOrganizationResDTO;
import java.util.ArrayList;

/**
 * 机构相关接口
 * 
 * @author fanheshui
 */
public interface BackstageOrganizationServiceApi {
  /**
   * 新增机构信息
   * 
   * @param BackstageOrganizationAddReqDTO
   */
  public DubboResult addBackstageOrganization(BackstageOrganizationAddReqDTO req);

  /**
   * 编辑机构信息
   * 
   * @param BackstageOrganizationUpdateReqDTO
   */
  public DubboResult updateBackstageOrganization(BackstageOrganizationUpdateReqDTO req);


  /**
   * 查询机构信息
   * 
   * @param BackstageOrganizationSearchReqDTO
   */
  public DubboResult<BackstageOrganizationResDTO> searchBackstageOrganization(
      BackstageOrganizationSearchReqDTO req);

  /**
   * 查询机构信息 列表
   * 
   * @param BackstageOrganizationListReqDTO
   */
  public DubboResult<PageInfo<BackstageOrganizationResDTO>> listBackstageOrganization(
      BackstageOrganizationListReqDTO req);

  /**
   * 查询机构信息 列表
   *
   * @param BackstageOrganizationListReqDTO
   */
  public DubboResult<ArrayList<BackstageOrganizationResDTO>> listBackstageOrganizationAll(
      SaasOrgRequestDTO requestDTO);

  /**
   * 更新机构状态
   */
  public DubboResult updateBackstageOrganizationStatus(Long orgId, StatusEnum status);
}
