package com.beiming.odr.user.api;


import java.util.ArrayList;
import java.util.List;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.dto.DictionaryInfoDTO;
import com.beiming.odr.user.api.dto.requestdto.DictionaryReqDTO;
import com.beiming.odr.user.api.dto.responsedto.CourtPaymentResDTO;
import com.beiming.odr.user.api.dto.responsedto.DictionaryResDTO;

/**
 * 字典
 * 
 * @author fhs
 * @date 2018年6月13日
 */
public interface DictionaryServiceApi {

  /**
   * 根据parentCode 查询字典项
   * 
   * @param dictionaryReqDTO
   */
  public DubboResult<DictionaryResDTO> searchDictionaryInfo(DictionaryReqDTO dictionaryReqDTO);

  /** 新增字典信息 */
  public DubboResult insertDictionary(DictionaryReqDTO dictionaryReqDTO);

  /*** 查询字典信息 */
  public DubboResult<DictionaryInfoDTO> searchDictionary(Long dictionaryId);

  /** 字典列表 */
  public DubboResult<PageInfo<DictionaryInfoDTO>> listDictionary(DictionaryReqDTO dictionaryReqDTO);
  
  /** 字典列表 */
  public DubboResult<ArrayList<DictionaryInfoDTO>> listDictionaryList(DictionaryReqDTO dictionaryReqDTO);

  /** 更新字典 */
  public DubboResult updateDictionary(DictionaryReqDTO dictionaryReqDTO);

  /** 删除字典 */
  public DubboResult deleteDictionary(Long dictionaryId);
  
  /** 通过父级代码数组查询字典信息 */
  public DubboResult<DictionaryResDTO> getDictionaryByParentCode(List<String> parentCodes);

  /** 批量新增字典信息 */
  DubboResult insertListDictionary(List<DictionaryReqDTO> dto);

  /**
   * 删除字典
   */
  DubboResult deleteDictionaryByParentCode(String parentCode);
  
  /**
   * 删除字典
   */
  DubboResult deleteDictionaryByCode(String code);

  /**
   * 查询二维码
   * @param string
   * @return
   */
  public String getQueryEwm(String code);

  /**
   * 查询用户角色
   * @param orgId
   * @return
   */
  public String getUserRole(Long orgId);

  DubboResult<DictionaryInfoDTO> getDictionaryInfoByCode(String code);

  DubboResult<CourtPaymentResDTO> getCourtPaymentInfo(String courtCode);
}
