package com.beiming.odr.user.api.auth;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.auth.dto.AuthAclInfoDTO;
import com.beiming.odr.user.api.auth.dto.AuthAclTreeDTO;
import com.beiming.odr.user.api.auth.dto.requestdto.AuthAclAddReqDTO;
import com.beiming.odr.user.api.auth.dto.requestdto.AuthAclListReqDTO;
import com.beiming.odr.user.api.auth.dto.requestdto.AuthAclQueryReqDTO;
import com.beiming.odr.user.api.auth.dto.requestdto.AuthAclTreeQueryRequestDTO;

/**
 * @ClassName AuthPermissionServiceApi
 * @Description
 * @Author xiet
 * @DATE 2020/1/2 1:24 PM
 * @VERSION 1.0
 **/
public interface AuthAclServiceApi {

  /**
   * 新增权限
   */
  DubboResult insertAuthAcl(AuthAclAddReqDTO authAclAddReqDTO);

  /**
   * 查询权限详情
   */
  DubboResult<AuthAclInfoDTO> getAuthAcl(AuthAclQueryReqDTO authAclQueryReqDTO);

  /**
   * 权限列表
   */
  DubboResult<PageInfo<AuthAclInfoDTO>> listAuthAcl(
      AuthAclListReqDTO authAclListReqDTO);

  /**
   * 更新权限
   */
  DubboResult updateAuthAcl(AuthAclAddReqDTO authAclAddReqDTO);

  /**
   * 删除权限
   */
  DubboResult deleteAuthAcl(AuthAclQueryReqDTO authAclQueryReqDTO);

  /**
   * 获取权限列表，用于给角色授权
   */
  DubboResult<PageInfo<AuthAclInfoDTO>> listAuthAclToRole();

  /**
   * 获取权限树
   */
  DubboResult<AuthAclTreeDTO> getAuthAclTree(AuthAclTreeQueryRequestDTO authAclTreeQueryRequestDTO);
}
