package com.beiming.odr.user.api.auth;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.auth.dto.requestdto.AuthRoleAddReqDTO;
import com.beiming.odr.user.api.auth.dto.requestdto.AuthRoleListReqDTO;
import com.beiming.odr.user.api.auth.dto.requestdto.AuthRoleSearchReqDTO;
import com.beiming.odr.user.api.auth.dto.responsedto.AuthRoleResDTO;
import java.util.ArrayList;

/**
 * @InterfaceName AuthPermissionServiceApi
 * @Description
 * @Author xiet
 * @DATE 2020/1/2 1:24 PM
 * @VERSION 1.0
 **/
public interface AuthRoleServiceApi {

  /**
   * 角色新增
   */
  DubboResult insertAuthRole(AuthRoleAddReqDTO authRoleAddReqDTO);

  /**
   * 角色修改
   */
  DubboResult updateAuthRole(AuthRoleAddReqDTO roleAddReqDTO);

  /**
   * 角色列表
   */
  DubboResult<PageInfo<AuthRoleResDTO>> listAuthRole(AuthRoleListReqDTO authRoleListReqDTO);

  /**
   * 获取角色信息
   */
  DubboResult<AuthRoleResDTO> getAuthRoleInfo(AuthRoleSearchReqDTO authRoleSearchReqDTO);

  /**
   * 角色删除
   */
  DubboResult deleteAuthRole(AuthRoleAddReqDTO authRoleAddReqDTO);

  /**
   * 获取系统默认角色，用在新增角色类型下拉框
   */
  DubboResult<ArrayList<AuthRoleResDTO>> getSysDefaultRole(AuthRoleListReqDTO authRoleListReqDTO);
}
