package com.beiming.odr.user.api.common.enums;

/**
 * 纠纷类型对应机构
 */
public enum OrgDisputeTypeEnum {
  TRAFFIC_ACCIDENT("ORG_TRAFFIC_ACCIDENT", "交通事故"), //交通事故多元化调解中心
  PROPERTY_DISPUTE("ORG_PROPERTY_DISPUTE", "物业纠纷"), //物业纠纷多元化调解中心
  CONSUMPTION_RIGHTS("ORG_CONSUMPTION_RIGHTS", "消费维权"), //消费者权益多元化调解中心
  MARITAL_INHERITANCE("ORG_MARITAL_INHERITANCE", "婚姻家庭"), //婚姻家庭纠纷多元化调解中心
  LABOUR_DISPUTE("ORG_LABOUR_DISPUTE", "劳动争议"), //劳动争议多元化调解中心
  ; 
  
  
  private String value;
  private String desc;

  OrgDisputeTypeEnum(String value, String desc) {
    this.value = value;
    this.desc = desc;
  }

  public String getValue() {
    return value;
  }
  
  public String getDesc() {
    return desc;
  }
}
