package com.beiming.odr.user.api.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.Pattern;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.common.enums.PersonTypeEnum;
import lombok.Data;

/**
 * 普通用户注册
 */
@Data
public class CaseUserRegisterReqDTO implements Serializable {


  /**
   * 手机号
   */
//  @Pattern(regexp = UserConst.REGEX_MOBILE_EXACT, message = "手机号码格式不对")
  private String mobilePhone;

  /**
   * 密码
   */
  @Pattern(regexp = UserConst.REGEX_PASSWORD, message = "密码格式错误")
  private String password;
  /**
   * 身份证
   */
  private String idCard;
  /**
   * 用户名称
   */
  private String userName;
  /**
   * 用户类型
   */
  private PersonTypeEnum personType;

  /**
   * 省
   */
  private String provinceCode;

  /**
   * 省名称
   */
  private String provinceName;

  /**
   * 市代码
   */
  private String cityCode;

  /**
   * 市名称
   */
  private String cityName;

  /**
   * 区代码
   */
  private String areaCode;

  /**
   * 区名称
   */
  private String areaName;

  /**
   * 街道代码
   */
  private String streetCode;

  /**
   * 街道名称
   */
  private String streetName;
  /**
   * 详细地址
   */
  private String detailedAddress;

}
