package com.beiming.odr.user.api.auth;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.user.api.auth.dto.requestdto.AuthUserRoleReqDTO;
import com.beiming.odr.user.api.auth.dto.requestdto.AutoAssignUserRoleReqDTO;
import com.beiming.odr.user.api.auth.dto.requestdto.BatchAuthUserRoleReqDTO;
import com.beiming.odr.user.api.auth.dto.requestdto.UserRouteAclReqDTO;
import com.beiming.odr.user.api.auth.dto.responsedto.AuthRoleAclResDTO;
import com.beiming.odr.user.api.auth.dto.responsedto.AuthUserRoleListResDTO;
import com.beiming.odr.user.api.auth.dto.responsedto.UserAuthRoleAclResDTO;
import java.util.ArrayList;
import java.util.List;

/**
 * @InterfaceName AuthUserRoleServiceApi
 * @Description
 * @Author xiet
 * @DATE 2020/1/9 12:24 AM
 * @VERSION 1.0
 **/
public interface AuthUserRoleServiceApi {

  /**
   * 给工作人员分配角色 分配除基础角色外的角色
   */
  void assignUserRoleForWorker(AuthUserRoleReqDTO authUserRoleReqDTO);

  /**
   * 给主被动注册用户分配角色 只能分配基础角色
   *
   * @Param com.beiming.odr.user.api.auth.dto.DefaultAuthRoleEnums
   */
  void assignUserRoleForRegister(AuthUserRoleReqDTO authUserRoleReqDTO);

  /**
   * 为被动注册用户分配角色
   */
  void assignUserForAutoRegister(AutoAssignUserRoleReqDTO autoAssignUserRoleReqDTO);

  /**
   * 为企业认证用户分配角色
   */
  void assignUserForCompanyAuth(AutoAssignUserRoleReqDTO autoAssignUserRoleReqDTO);

  /**
   * 批量分配角色
   */
  void batchAssignUserRole(BatchAuthUserRoleReqDTO batchAuthUserRoleReqDTO);

  /**
   * 通过用户ID查询拥有的权限
   */
  List<AuthRoleAclResDTO> getAllUserAuthAcl(UserRouteAclReqDTO userRouteAclReqDTO);

  /**
   * 通过用户ID和前端路由获取当前路由的按钮权限列表
   */
  List<AuthRoleAclResDTO> getUserRouterAcl(UserRouteAclReqDTO userRouteAclReqDTO);

  /**
   * 通过用户ID和RoleCode查询拥有的权限和角色列表，并切换到RoleCode对应角色
   */
  DubboResult<UserAuthRoleAclResDTO> getUserAllAcl(UserRouteAclReqDTO userRouteAclReqDTO);

  /**
   * 通过用户ID查询已有角色数据
   */
  DubboResult<ArrayList<AuthUserRoleListResDTO>> getUserAllRole(
      UserRouteAclReqDTO userRouteAclReqDTO);

}
