package com.beiming.odr.user.api.dto.responsedto;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.Pattern;
import com.alibaba.fastjson.JSONArray;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.common.constants.ValidateMessage;
import com.beiming.odr.user.api.dto.UserRoleInfoDTO;
import lombok.Data;


/**
 * 工作人员返回信息
 */
@Data
public class BackstageUserInfoResDTO implements Serializable {

  public BackstageUserInfoResDTO() {

  }

  /**
   * 用户id
   */
  private Long userId;
  /**
   * 姓名
   */
  private String userName;

  /**
   * 账户名
   */
  private String loginName;
  /**
   * 手机号
   */
  private String mobilePhone;

  /**
   * 身份证
   */
  private String idCard;

  /**
   * 密码
   */
  @Pattern(regexp = UserConst.REGEX_PASSWORD, message = ValidateMessage.MOBILE_PHONE_INCORRECT)
  private String password;

  /**
   * 用户角色
   */
  private List<UserRoleInfoDTO> userRole;

  /**
   * 创建人
   */
  private String createUser;

  /**
   * 创建时间
   */
  private Date createTime;

  /**
   * 修改人
   */
  private String updateUser;

  /**
   * 修改时间
   */
  private Date updateTime;


  /**
   * 角色名称
   */
  private String roleName;

  /**
   * 用户状态
   */
  private String status;

  /**
   * 机构ID
   */
  private Long orgId;

  /**
   * 机构名称
   */
  private String orgName;

  /**
   * 文化程度
   */
  private String education;

  /**
   * 出生日期
   */
  private String birthday;

  /**
   * 政治面貌
   */
  private String politicalOutlook;

  /**
   * 邮箱
   */
  private String email;

  /**
   * 职业类型
   */
  private String occupation;

  /**
   * 擅长领域
   */
  private String ability;

  /**
   * 从业经历
   */
  private String experience;


  /** 用户地址 */
  private JSONArray userAddress;
  /**
   * 用户证件集合
   */
  private JSONArray userCertificates;

  /** 性别 */
  private String sex;

  /** 头像 */
  private String headPortraitUrl;

  /** 职业 */
  private String job;

  /** 人员类型 */
  private String personType;

  /** 机构行政等级 */
  private Integer orgGradeLevel;

  /**
   * 工作单位
   */
  private String workOrganization;

  private Integer personalSchedules;

  private Integer courtSchedules;

  private Integer statistics;

  private Integer peopleManagement;

  private Long departId;

  private String gatewayStatus;

  private String departName;

}
