package com.beiming.odr.user.api.common.enums;

/**
 * 地区人口（万人）枚举
 * @author jiangyanfeng
 */
public enum AreaPopulationEnum {
  HUAIAN("", "淮安市", 493.26),
  HUAIAN_KAIFA("", "开发区", 31.82),
  HUAIAN_QINGJIANGPU("", "清江浦", 71.43),
  HUAIAN_HUAIYIN("", "淮阴区", 78.43),
  HUAIAN_HUAIANQU("", "淮安区", 94.79),
  HUAIAN_HONGZE("", "洪泽区", 33.11),
  HUAIAN_LIANSHUI("", "涟水县", 84.84),
  HUAIAN_JINHU("", "金湖县", 33.24),
  HUAIAN_XUYI("", "盱眙县", 65.60);

  private String areaCode;

  private String areaName;

  private Double population; // 万人

  AreaPopulationEnum(String areaCode, String areaName, Double population) {
    this.areaCode = areaCode;
    this.areaName = areaName;
    this.population = population;
  }

  public String getAreaCode() {
    return areaCode;
  }

  public String getAreaName() {
    return areaName;
  }

  public Double getPopulation() {
    return population;
  }
}
