package com.beiming.odr.user.api.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import com.beiming.odr.user.api.common.constants.UserConst;
import lombok.Data;


/**
 * 工作人员新增参数-用户没有角色
 */
@Data
public class BackstageUserNoRoleAddReqDTO implements Serializable {

  /**
   * 用户id
   */
  private Long userId;

  /**
   * 姓名
   */
  private String userName;
  /**
   * 手机号
   */
  @NotBlank(message = "手机号码不能为空")
  @Pattern(regexp = UserConst.REGEX_MOBILE_EXACT, message = "手机号码格式错误")
  private String mobilePhone;

  /** 菜单id，用逗号隔开 */
  String menuId;
  /**
   * 职业类型
   */
  private String occupation;
}
