package com.beiming.odr.user.api.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.Pattern;
import com.beiming.odr.user.api.common.constants.UserConst;
import lombok.Data;

/**
 * 微信登录
 */
@Data
public class UserLoginByWechatReqDTO implements Serializable {
  
  private static final long serialVersionUID = -2140684033440883400L;
  
  /**
   * openId
   */
  private String openId;
  
  /**
   * 手机号码
   */
  @Pattern(regexp = UserConst.REGEX_MOBILE_EXACT, message = "手机号码格式错误")
  private String mobilePhone;

}
