package com.beiming.odr.user.api;

import java.util.List;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.dto.UserEvaluateDTO;
import com.beiming.odr.user.api.dto.requestdto.CaseIsEvaluateReqDTO;
import com.beiming.odr.user.api.dto.requestdto.UserEvaluateGradeCountListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.UserEvaluateGradeCountReqDTO;
import com.beiming.odr.user.api.dto.requestdto.UserEvaluateListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.UserEvaluatePageListReqDTO;
import com.beiming.odr.user.api.dto.responsedto.CaseIsEvaluateResDTO;
import com.beiming.odr.user.api.dto.responsedto.UserEvaluateGradeCountListResDTO;
import com.beiming.odr.user.api.dto.responsedto.UserEvaluateGradeCountResDTO;
import com.beiming.odr.user.api.dto.responsedto.UserEvaluateResDTO;



public interface UserEvaluateServiceApi {

  /**
   * 获取用户评价列表
   * @param userEvaluateListRequestDTO
   * @return List<UserEvaluate>
   */
  public DubboResult<UserEvaluateResDTO> getUserEvaluateList(UserEvaluateListReqDTO userEvaluateListReqDTO);
  
  /**
   * 获取用户评价分页列表
   * @param userEvaluatePageListReqDTO
   * @return
   */
  public DubboResult<PageInfo<UserEvaluateDTO>> getUserEvaluatePageList(UserEvaluatePageListReqDTO userEvaluatePageListReqDTO);
  
  /**
   * 保存用户评价
   * @param saveUserEvaluateRequestDTO
   * @return
   */
  public DubboResult<Boolean> saveUserEvaluate(UserEvaluateDTO userEvaluateDTO);
  
  /**
   * 查询用户评价数和星星数
   * @param userEvaluateGradeCountReqDTO
   * @return
   */
  public DubboResult<UserEvaluateGradeCountResDTO> getUserEvaluateGradeCount(UserEvaluateGradeCountReqDTO userEvaluateGradeCountReqDTO);
  
  /**
   * 查询用户评价数和星星数（多用户）
   * @param userEvaluateGradeCountListReqDTO
   * @return
   */
  public DubboResult<UserEvaluateGradeCountListResDTO> getUserEvaluateGradeCountList(UserEvaluateGradeCountListReqDTO userEvaluateGradeCountListReqDTO);
  
  /**
   * 案件是否已评价
   * @param caseIsEvaluateReqDTO
   * @return
   */
  public DubboResult<CaseIsEvaluateResDTO> getCaseIsEvaluate(CaseIsEvaluateReqDTO caseIsEvaluateReqDTO);
  
  /**
   *  信访代理人是否已评价
   * @param userEvaluateDTOs
   * @return
   */
  public DubboResult<CaseIsEvaluateResDTO> getPetitionAgentIsEvaluate(List<UserEvaluateDTO> userEvaluateDTOs);
}
