package com.beiming.odr.user.api.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import lombok.Data;

/**
 * 用户扩展信息
 */
@Data
public class UserExtInfoReqDTO implements Serializable {

  private static final long serialVersionUID = 7172176350040471394L;

  /**
   * 用户ID
   */
  @NotNull(message = "用户ID不能为空")
  private Long userId;

  /**
   * 签名文件访问路径
   */
  @NotBlank(message = "签名文件访问路径不能为空")
  private String signatureFileUrl;

  /**
   * 签名文件名
   */
  private String signatureFileName;

  /**
   * 签名文件类型
   */
  private String signatureFileSuffix;

  /**
   * 签名文件大小
   */
  private Integer signatureFileSize;
  
  private String remark;

}
