package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.user.api.common.enums.UserLoginTypeEnum;
import com.beiming.odr.user.api.dto.UserInfoDTO;
import com.beiming.odr.user.api.dto.requestdto.UserExtInfoReqDTO;
import com.beiming.odr.user.api.dto.responsedto.LoginInfoResDTO;
import com.beiming.odr.user.api.dto.responsedto.UserExtInfoResDTO;
import com.beiming.odr.user.api.dto.responsedto.UserExtSingnatureInfoDto;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.validation.Valid;

@Valid
public interface UserExtInfoServiceApi {

  /**
   * 保存或更新用户扩展信息
   * 
   * @param userExtInfoReqDTO
   * @return
   * @author djq
   * @date 2019年7月8日
   */
  DubboResult<UserExtInfoResDTO> addUserExtInfo(@Valid UserExtInfoReqDTO userExtInfoReqDTO);

  /**
   * 获取用户扩展信息列表
   * 
   * @param userId
   * @return
   * @author djq
   * @date 2019年7月8日
   */
  DubboResult<ArrayList<UserExtInfoResDTO>> queryUserExtInfo(Long userId);
  
  DubboResult<ArrayList<UserExtInfoResDTO>> getUserExtInfo(Long userId, String remark);
  
  /**
   * 根据remark获取用户签名信息
   * @param remark
   * @return
   */
  DubboResult<ArrayList<UserExtSingnatureInfoDto>> getUserExtInfoByRemark(Long userid,
      String remark);
  
  DubboResult delUserExtInfo(Long userId, String remark);
  
  DubboResult<UserInfoDTO> searchUserInfoByIdCard(String idCard);

  /**
   * 用户登录 -通过mobile
   * 
   * @param mobile
   * @param loginType
   */
  DubboResult<LoginInfoResDTO> userLogin(String mobile, UserLoginTypeEnum loginType);

  DubboResult<UserExtInfoResDTO> getUserSignAndEmail(Long userId, String roomId);

  DubboResult<String> getUserLastSignTime(List<Long> userIdlist, String roomId);

  /**
   * 广州仲裁获取用户案件签名信息
   * @param userId
   * @param remark
   * @return
   */
  DubboResult<Date> gzzcUserLastSignTime(Long userId, String remark);

}
