package com.beiming.odr.user.api.dto;

import java.io.Serializable;
import java.util.Date;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author sunzheng
 * @date 2023/07/05
 */

/**
 * 地域表
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class UserAreas implements Serializable {

  /**
   * 自增id
   */
  private Long id;

  /**
   * 地区代码
   */
  private String code;

  /**
   * 地区名称
   */
  private String name;

  /**
   * 加上父级的名称和自己的名称
   */
  private String fullName;

  /**
   * 等级
   */
  private Integer level;

  /**
   * 父级地区代码
   */
  private String parentCode;

  /**
   * 状态 0 正常 1 删除
   */
  private String status;

  /**
   * 备注
   */
  private String remark;

  /**
   * 创建人
   */
  private String createUser;

  /**
   * 创建时间
   */
  private Date createTime;

  /**
   * 修改人
   */
  private String updateUser;

  /**
   * 更新时间
   */
  private Date updateTime;

  /**
   * 版本号
   */
  private Integer version;

  private static final long serialVersionUID = 4995502397692103020L;
}