package com.beiming.odr.user.api.dto;

import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
@AllArgsConstructor
public class UserMenuInfoDTO implements Serializable {


  public UserMenuInfoDTO(Long id, Long parentId, String menuName, String menuUrl,
      String menuType, Integer menuOrderNo, String remark) {
    this.id = id;
    this.parentId = parentId;
    this.menuName = menuName;
    this.menuUrl = menuUrl;
    this.menuType = menuType;
    this.menuOrderNo = menuOrderNo;
    this.remark = remark;
  }

  public UserMenuInfoDTO(Long userId, Long id, Long parentId, String menuName, String menuUrl,
      Integer menuOrderNo) {
    this.userId = userId;
    this.id = id;
    this.parentId = parentId;
    this.menuName = menuName;
    this.menuUrl = menuUrl;
    this.menuOrderNo = menuOrderNo;
  }

  /**
   * 用户id
   */
  private Long userId;

  /**
   * id
   */
  private Long id;
  /**
   * 父级菜单id
   */
  private Long parentId;

  /**
   * 菜单名称
   */
  private String menuName;

  /**
   * 菜单路径
   */
  private String menuUrl;

  /**
   * 菜单类型
   */
  private String menuType;

  /**
   * 菜单排序
   */
  private Integer menuOrderNo;

  private String remark;

}
