package com.beiming.odr.user.api.dto.requestdto.newsinformation;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import com.beiming.odr.user.api.common.enums.PublishStatusEnums;
import lombok.Data;

/**
 * 添加新闻
 */
@Data
public class AddReqDTO implements Serializable {
  /**
   * 标题
   */
  private String title;

  /**
   * 缩略图
   */

  private String imgUrl;

  /**
   * 作者
   */
  private String author;

  /**
   * 来源渠道
   */
  private String sourceChannel;

  /**
   * 新闻类型代码
   */
  @NotBlank(message = "新闻类型代码不能为空")
  private String newsTypeCode;

  /**
   * 新闻类型名称
   */
  private String newsTypeName;

  /**
   * 内容简介
   */
  private String shortContent;
  /**
   * 内容
   */
  private String content;

  /**
   * 发布时间
   */
  private Date publishDate;

  /**
   * 发布状态(Unpublished 未发布，published 发布，Revoke 撤销)
   */
  @NotNull(message = "发布状态不能为空")
  private PublishStatusEnums publishStatus;
  
  /** 增殖放流,stock_enhancement*/
  private String remark;
  
  /**
   * 附件
   */
  private List<NewsInformationAttachmentReqDTO> attachmentList;
}
