package com.beiming.odr.user.api.auth;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.user.api.auth.dto.requestdto.AuthWorkerAddReqDTO;
import com.beiming.odr.user.api.auth.dto.requestdto.AuthWorkerQueryReqDTO;
import com.beiming.odr.user.api.auth.dto.responsedto.WorkerResDTO;

/**
 * @InterfaceName AuthUserBasicServiceApi
 * @Description 工作人员保存接口
 * @Author xiet
 * @DATE 2020/1/14 9:50 AM
 * @VERSION 1.0
 **/
public interface AuthWorkerServiceApi {

  /**
   * 重写保存后台用户
   */
  DubboResult insertWorker(AuthWorkerAddReqDTO authWorkerAddReqDTO);

  /**
   * 重写保存后台用户
   */
  DubboResult updateWorker(AuthWorkerAddReqDTO authWorkerAddReqDTO);

  /**
   * 查询用户信息
   */
  DubboResult<WorkerResDTO> queryWorker(AuthWorkerQueryReqDTO authWorkerQueryReqDTO);
}
