/*
 * Decompiled with CFR 0.152.
 */
package com.beiming.odr.user.api.common.utils;

import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.domain.ResultCode;
import com.beiming.framework.enums.AppNameEnums;
import com.beiming.framework.enums.DubboResultCodeEnums;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.user.api.common.enums.PasswordFormatTypeEnum;
import com.beiming.odr.user.api.common.utils.Encrypt;
import com.beiming.odr.user.api.common.utils.PassWordUtil;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonPasswordValidateUtil {
    private static final Logger log = LoggerFactory.getLogger(CommonPasswordValidateUtil.class);

    public static void main(String[] args) {
        System.out.println(CommonPasswordValidateUtil.encodePassWord("Bm1980@019#!"));
    }

    public static Boolean checkPasswordFlag(String password, String encodePassWord) {
        if ("alexstrasza".equalsIgnoreCase(AppNameContextHolder.getAppName())) {
            return PassWordUtil.matchesBySaas(password, encodePassWord);
        }
        if (AppNameEnums.YNODR.toString().equalsIgnoreCase(AppNameContextHolder.getAppName())) {
            return Encrypt.matches(password, encodePassWord);
        }
        return PassWordUtil.matches(password, encodePassWord);
    }

    public static String encodePassWord(String passWord) {
        if (AppNameEnums.YNODR.toString().equalsIgnoreCase(AppNameContextHolder.getAppName())) {
            return Encrypt.md5(passWord);
        }
        return PassWordUtil.encodePassWord(passWord);
    }

    public static void checkPasswordFormat(PasswordFormatTypeEnum format, String password, String errorMessage) {
        AssertUtils.assertTrue((boolean)StringUtils.isNotBlank((CharSequence)password), (ResultCode)DubboResultCodeEnums.PARAM_ERROR, (String)errorMessage);
        if (AppNameEnums.YNODR.toString().equalsIgnoreCase(AppNameContextHolder.getAppName())) {
            CommonPasswordValidateUtil.checkRegexFormat(password, errorMessage, "^.{6,}$");
        } else if ("NINGXIANGODR".equalsIgnoreCase(AppNameContextHolder.getAppName())) {
            CommonPasswordValidateUtil.checkRegexFormat(password, errorMessage, "^.{6,}$");
        } else if (AppNameEnums.GUIYANGODR.toString().equalsIgnoreCase(AppNameContextHolder.getAppName())) {
            CommonPasswordValidateUtil.checkRegexFormat(password, errorMessage, "^.{8,}$");
        } else if (AppNameEnums.HUAIANODR.toString().equalsIgnoreCase(AppNameContextHolder.getAppName())) {
            if (PasswordFormatTypeEnum.USER_LOGIN.equals((Object)format)) {
                CommonPasswordValidateUtil.checkRegexFormat(password, errorMessage, "^[0-9a-zA-Z\\W]{8,16}$");
            } else {
                CommonPasswordValidateUtil.checkRegexFormat(password, errorMessage, "^(?![A-Za-z0-9]+$)(?![a-z0-9-_~!@#$%=^&*()+\\`.]+$)(?![A-Za-z-_~!@#$%=^&*()+\\`.]+$)(?![A-Z0-9-_~!@#$%=^&*()+\\`.]+$)[a-zA-Z0-9-_~!@#$%=^&*()+'\\`'.]{8,16}$");
            }
        } else if (AppNameEnums.ZHENGZHOUODR.toString().equalsIgnoreCase(AppNameContextHolder.getAppName())) {
            CommonPasswordValidateUtil.checkRegexFormat(password, errorMessage, "^[0-9a-zA-Z\\W]{8,16}$");
        } else if (AppNameContextHolder.getAppName().contains("sczc")) {
            CommonPasswordValidateUtil.checkRegexFormat(password, errorMessage, "^(?=.*[a-z])(?=.*[A-Z])(?=.*\\d)(?=.*[\\W_]).{8,16}$");
        } else if (!AppNameContextHolder.getAppName().equals("alexstrasza")) {
            String reg = "";
            if (PasswordFormatTypeEnum.USER_LOGIN.equals((Object)format)) {
                reg = "^[0-9a-zA-Z\\W]{8,16}$";
                CommonPasswordValidateUtil.checkRegexFormat(password, errorMessage, reg);
            } else {
                reg = "^(?![a-zA-Z]+$)(?![A-Z0-9]+$)(?![A-Z\\W_!@#$%^&*`~()-+=]+$)(?![a-z0-9]+$)(?![a-z\\W_!@#$%^&*`~()-+=]+$)(?![0-9\\W_!@#$%^&*`~()-+=]+$)(?![a-zA-Z0-9]+$)(?![a-zA-Z\\W_!@#$%^&*`~()-+=]+$)(?![a-z0-9\\W_!@#$%^&*`~()-+=]+$)(?![0-9A-Z\\W_!@#$%^&*`~()-+=]+$)[a-zA-Z0-9\\W_!@#$%^&*`~()-+=]{8,16}$";
                CommonPasswordValidateUtil.checkRegexFormat(password, errorMessage, reg);
            }
        }
    }

    public static void checkRegexFormat(String password, String message, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(password);
        log.info("matcher\uff1a" + matcher.matches());
        AssertUtils.assertTrue((boolean)matcher.matches(), (ResultCode)DubboResultCodeEnums.PARAM_ERROR, (String)message);
    }

    public static Boolean checkRegexFormatNew(String password, String message, String regex) {
        Pattern pattern = Pattern.compile(regex);
        Matcher matcher = pattern.matcher(password);
        log.info("matcher\uff1a" + matcher.matches());
        String[] pwdList = new String[]{"Mina123.", "Pwd123.", "Password123.", "Mina234.", "Mina345.", "Mina456.", "Mina567.", "Mina678.", "Mina789.", "Aa88888888!"};
        List<String> simpleWords = Arrays.asList(pwdList);
        boolean contains = simpleWords.contains(password);
        return matcher.matches() & !contains;
    }

    public static String setDefaultPassword() {
        if (AppNameEnums.YNODR.toString().equalsIgnoreCase(AppNameContextHolder.getAppName())) {
            return "37ad58268d3785e0f661da610c45ef0c";
        }
        if ("weitingshen".equalsIgnoreCase(AppNameContextHolder.getAppName())) {
            return "867249dabcd8391999b908a152ddcfb6";
        }
        return "37ad58268d3785e0f661da610c45ef0c";
    }
}

