package com.beiming.odr.user.api.auth.dto.requestdto;

import com.beiming.framework.domain.BaseObject;
import java.io.Serializable;
import lombok.Data;

/**
 * @ClassName PermissionInfoReqDTO
 * @Description 权限新增请求对象
 * @Author xiet
 * @DATE 2020/1/8 4:57 PM
 * @VERSION 1.0
 **/
@Data
public class AuthAclAddReqDTO extends BaseObject implements Serializable {

  /**
   * 权限id
   */
  private Long id;

  /**
   * 父级权限 id
   */
  private Long aclParentId;

  /**
   * 权限名称
   */
  private String aclName;

  /**
   * 权限描述
   */
  private String aclDesc;

  /**
   * 权限路由
   */
  private String aclRouter;

  /**
   * 权限类型
   */
  private String aclType;

  /**
   * 权限url表达式
   */
  private String aclUrl;

  /**
   * 权限是否可见
   */
  private Integer aclVisible;

  /**
   * 权限排序
   */
  private Integer aclOrderNo;

}
