package com.beiming.odr.user.api.dto;

import java.io.Serializable;
import lombok.Data;
import lombok.NoArgsConstructor;

@Data
@NoArgsConstructor
public class OrgDataImportBean implements Serializable {

  /**
   *
   */
  private static final long serialVersionUID = -6723251982605172748L;

  /**
   * 机构代码
   */
  private String code;

  /**
   * 机构名称
   */
  private String name;

  /**
   * 父级id
   */
  private String parentId;

  /**
   * 父级name
   */
  private String parentName;

  /**
   * 机构类型代码
   */
  private String typeCode;

  /**
   * 机构类型名称
   */
  private String typeName;

  /**
   * 调解类型代码
   */
  private String mediateCode;

  /**
   * 调解类型名称
   */
  private String mediateName;

  /**
   * 组织机构证书图片
   */
  private String imgUrl;

  /**
   * 省
   */
  private String provinceCode;

  /**
   * 省名称
   */
  private String provinceName;

  /**
   * 市代码
   */
  private String cityCode;

  /**
   * 市名称
   */
  private String cityName;

  /**
   * 区代码
   */
  private String areaCode;

  /**
   * 区名称
   */
  private String areaName;

  /**
   * 街道代码
   */
  private String streetCode;

  /**
   * 街道名称
   */
  private String streetName;

  /**
   * 社区代码
   */
  private String communityCode;

  /**
   * 社区名称
   */
  private String communityName;

  /**
   * 详细地址
   */
  private String detailedAddress;

  /**
   * 座机电话
   */
  private String seatPhone;

  /**
   * 机构logo图片
   */
  private String logoImgUrl;

  /**
   * 联系人
   */
  private String contactName;

  /**
   * 联系人职位
   */
  private String contactPosition;

  /**
   * 联系人电话
   */
  private String contactPhone;

  /**
   * 联系人邮件
   */
  private String contactEmail;

  /**
   * 联系人照片
   */
  private String contactImgUr;

  /**
   * 行政级别
   */
  private Byte grade;

  /**
   * 行政级别等级
   */
  private Byte gradeLevel;


  /**
   * 纠纷类型CODE
   */
  private String disputeTypeCode;

  /**
   * 纠纷类型名称
   */
  private String disputeTypeName;

  /**
   * 批次ID
   */
  private String batchCode;

  /**
   * 机构简介
   */
  private String introduction;

  /**
   * <pre>
   * @param inputs 输入参数列表，顺序如下：
   * </pre>
   *
   * @param name            机构名称
   * @param typeName        机构类型
   * @param mediateName     调解类型名称
   * @param disputeTypeName 纠纷类型名称
   * @param contactName     联系人
   * @param contactPhone    联系人电话
   * @param detailedAddress 详细地址
   * @param provinceName    省名称
   * @param cityName        市名称
   * @param areaName        区名称
   * @param streetName      街道名称
   * @param communityName   社区名称
   * @param batchCode       批次ID
   */
  public OrgDataImportBean(String[] inputs, String batchCode, String templateName) {
    super();
    this.name = inputs[0];
    this.typeName = inputs[1];
    if ("org".equals(templateName)) {
      this.mediateName = inputs[2];
      if (inputs[6] != null && inputs[6].split("_").length == 2) {
        this.provinceName = inputs[6].split("_")[0];
        this.provinceCode = inputs[6].split("_")[1];
      }
      if (inputs[7] != null && inputs[7].split("_").length == 2) {
        this.cityName = inputs[7].split("_")[0];
        this.cityCode = inputs[7].split("_")[1];
      }
      if (inputs[8] != null && inputs[8].split("_").length == 2) {
        this.areaName = inputs[8].split("_")[0];
        this.areaCode = inputs[8].split("_")[1];
      }
      if (inputs[9] != null && inputs[9].split("_").length == 2) {
        this.streetName = inputs[9].split("_")[0];
        this.streetCode = inputs[9].split("_")[1];
      }
      if (inputs[10] != null && inputs[10].split("_").length == 2) {
        this.communityName = inputs[10].split("_")[0];
        this.communityCode = inputs[10].split("_")[1];
      }
      this.detailedAddress = inputs[5];
      this.contactName = inputs[3];
      this.contactPhone = inputs[4];
    } else if ("court".equals(templateName) || "arbitrate".equals(templateName)) {
      this.contactPhone = inputs[2];
      this.detailedAddress = inputs[3];
      if (inputs[4] != null && inputs[4].split("_").length == 2) {
        this.provinceName = inputs[4].split("_")[0];
        this.provinceCode = inputs[4].split("_")[1];
      }
      if (inputs[5] != null && inputs[5].split("_").length == 2) {
        this.cityName = inputs[5].split("_")[0];
        this.cityCode = inputs[5].split("_")[1];
      }
      if (inputs[6] != null && inputs[6].split("_").length == 2) {
        this.areaName = inputs[6].split("_")[0];
        this.areaCode = inputs[6].split("_")[1];
      }
      if (inputs[7] != null && inputs[7].split("_").length == 2) {
        this.streetName = inputs[7].split("_")[0];
        this.streetCode = inputs[7].split("_")[1];
      }
      if (inputs[8] != null && inputs[8].split("_").length == 2) {
        this.communityName = inputs[8].split("_")[0];
        this.communityCode = inputs[8].split("_")[1];
      }
    }
    this.batchCode = batchCode;
  }

  /**
   * <pre>
   * @param inputs 输入参数列表，顺序如下：
   * </pre>
   *
   * @param name            机构名称
   * @param typeName        机构类型
   * @param mediateName     调解类型名称
   * @param disputeTypeName 纠纷类型名称
   * @param contactName     联系人
   * @param contactPhone    联系人电话
   * @param detailedAddress 详细地址
   * @param provinceName    省名称
   * @param cityName        市名称
   * @param areaName        区名称
   * @param streetName      街道名称
   * @param communityName   社区名称
   * @param batchCode       批次ID
   */
  public OrgDataImportBean(String[] inputs, String batchCode) {
    super();
    this.name = inputs[0];
    this.typeName = inputs[1];
    this.mediateName = inputs[2];
    if (inputs[6] != null && inputs[6].split("_").length == 2) {
      this.provinceName = inputs[6].split("_")[0];
      this.provinceCode = inputs[6].split("_")[1];
    }
    if (inputs[7] != null && inputs[7].split("_").length == 2) {
      this.cityName = inputs[7].split("_")[0];
      this.cityCode = inputs[7].split("_")[1];
    }
    if (inputs[8] != null && inputs[8].split("_").length == 2) {
      this.areaName = inputs[8].split("_")[0];
      this.areaCode = inputs[8].split("_")[1];
    }
    if (inputs[9] != null && inputs[9].split("_").length == 2) {
      this.streetName = inputs[9].split("_")[0];
      this.streetCode = inputs[9].split("_")[1];
    }
    if (inputs[10] != null && inputs[10].split("_").length == 2) {
      this.communityName = inputs[10].split("_")[0];
      this.communityCode = inputs[10].split("_")[1];
    }
    this.detailedAddress = inputs[5];
    this.contactName = inputs[3];
    this.contactPhone = inputs[4];
    this.batchCode = batchCode;

  }

  @Override
  public String toString() {
    return "OrganizationImportTemp [code=" + code + ", name=" + name + ", parentId=" + parentId
        + ", parentName=" + parentName + ", typeCode=" + typeCode + ", typeName=" + typeName
        + ", mediateCode=" + mediateCode + ", mediateName=" + mediateName + ", imgUrl=" + imgUrl
        + ", provinceCode=" + provinceCode + ", provinceName=" + provinceName + ", cityCode="
        + cityCode + ", cityName=" + cityName + ", areaCode=" + areaCode + ", areaName="
        + areaName
        + ", streetCode=" + streetCode + ", streetName=" + streetName + ", communityCode="
        + communityCode + ", communityName=" + communityName + ", detailedAddress="
        + detailedAddress + ", seatPhone=" + seatPhone + ", logoImgUrl=" + logoImgUrl
        + ", contactName=" + contactName + ", contactPosition=" + contactPosition
        + ", contactPhone=" + contactPhone + ", contactEmail=" + contactEmail + ", contactImgUr="
        + contactImgUr + ", grade=" + grade + ", gradeLevel=" + gradeLevel + ", disputeTypeCode="
        + disputeTypeCode + ", disputeTypeName=" + disputeTypeName + ", batchCode=" + batchCode
        + ", introduction=" + introduction + "]";
  }

}
