package com.beiming.odr.user.api.dto.requestdto;

import java.io.Serializable;
import java.util.Date;
import lombok.Data;
import org.hibernate.validator.constraints.NotBlank;
import com.beiming.odr.user.api.common.constants.ValidateMessage;
import com.beiming.odr.user.api.common.enums.StatusEnum;
import com.beiming.odr.user.api.page.QueryPageParam;

/**
 * 用户注册
 */
@Data
public class RoleReqDTO extends QueryPageParam implements Serializable {
  /**
   * 自增
   */

  /**
   * 角色名称
   */
  @NotBlank(message = ValidateMessage.NAME_NOT_BLANK)
  private String roleName;

  /**
   * 角色代码
   */
  @NotBlank(message = ValidateMessage.CODE_NOT_BLANK)
  private String roleCode;
  /**
   * 状态 0 正常 1 删除
   */
  private StatusEnum status;

  /**
   * 备注
   */
  private String remark;

  /**
   * 创建人
   */
  private String createUser;

  /**
   * 创建时间
   */
  private Date createTime;

  /**
   * 修改人
   */
  private String updateUser;

  /**
   * 修改时间
   */
  private Date updateTime;

  /**
   * 版本号
   */
  private Integer version;

}
