package com.beiming.odr.user.api.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import com.beiming.odr.user.api.common.constants.UserConst;
import lombok.Data;

/**
 * 用户登录-吉林微法院登录请求参数
 */
@Data
public class UserLoginByMicroCourtReqDTO implements Serializable {
  
  /**
   * 手机号
   */
  @NotBlank(message = "手机号码不能为空")
  @Pattern(regexp = UserConst.REGEX_MOBILE_EXACT, message = "手机号码格式错误")
  private String mobilePhone;

  /**
   * jscode
   */
  @NotBlank(message = "openId不能为空")
  private String openId;

  /**
   * 姓名
   */
  @NotBlank(message = "姓名不能为空")
  private String userName;

  /**
   * 身份证
   */
  @NotBlank(message = "身份证不能为空")
  @Pattern(regexp = UserConst.REGEX_ID_CARD, message = "身份证格式错误")
  private String idCard;

}
