package com.beiming.odr.user.api.dto.responsedto;

import com.beiming.framework.enums.CTypeEnums;
import com.beiming.odr.user.api.common.enums.RegisterOriginEnum;
import java.io.Serializable;
import java.util.Date;
import lombok.Data;

@Data

public class UserBasicsResDto implements Serializable {

  private static final long serialVersionUID = 1L;
  /**
   * 用户登录名
   */
  private String loginName;

  /**
   * 手机号
   */
  private String mobilePhone;

  /**
   * 身份证
   */
  private String idCard;

  /**
   * 用户姓名
   */
  private String userName;

  /**
   * 头像
   */
  private String headPortraitUrl;

  /**
   * 密码
   */
  private String password;

  /**
   * 是否实名
   */
  private Boolean isRealName;

  /**
   * 是否完成人脸识别
   */
  private Boolean isFacialVerify;

  /**
   * 最后登录时间
   */
  private Date lastLoginTime;

  /**
   * 人员类型
   */
  private String personType;


  /**
   * 业务人员类型
   * */
  private String businessPeopleType;
  
  /**
   * 微信openId
   */
  private String openId;
  /**
   * 用户主被动标识
   * @see RegisterOriginEnum
   */
  private String registerOrigin;
  /**
   * 注册来源
   * @see CTypeEnums
   */
  private String registrationSource;
}
