package com.beiming.odr.user.api;


import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.dto.UserInfoDTO;
import com.beiming.odr.user.api.dto.requestdto.OrganizationListReqDTO;
import com.beiming.odr.user.api.dto.responsedto.OrgProResDTO;
import com.beiming.odr.user.api.dto.responsedto.OrganizationResDTO;
import com.beiming.odr.user.api.dto.responsedto.ServicePersonNumberResDTO;
import com.beiming.odr.user.api.dto.responsedto.UserOrgDetailsResDTO;
import java.util.ArrayList;
import java.util.List;


public interface OrganizationSecondServiceApi {


  /**
   * 获取机构列表分页(淮安)
   *
   * @param organizationListReqDTO
   * @return
   */
  public DubboResult<PageInfo<OrganizationResDTO>> getOrganizationListPageH(
      OrganizationListReqDTO organizationListReqDTO);


  /**
   * 查询机构下服务人员的数量
   *
   * @param orgId
   * @return
   */
  public DubboResult<ServicePersonNumberResDTO> getServicePersonNumberH(List<Long> orgIds,
      String currentUserId);

  /**
   * 给湖北庭审用的。 优先湖北庭审-庭审-其他
   */
  public DubboResult<ArrayList<Long>> queryOrgIdByAreaCode(String code, String queryColumn);

  /**
   * 根据地区码查询地区内机构
   *
   * @param code
   * @param queryColumn
   * @return
   */
  public DubboResult<ArrayList<OrganizationResDTO>> queryOrganizationByAreaCode(String code,
      String queryColumn);

  /**
   * 根据法院id列表查询省份名称和code列表
   */
  public DubboResult<ArrayList<OrgProResDTO>> getProCodesAndNamesByOrgIds(List<Integer> orgIds);

  /**
   * 根据机构id 查询审判组织
   */
  public DubboResult<ArrayList<UserInfoDTO>> getUserInfoListByOrgIdAndRoleType(Long orgId);

  /**
   * 根据地区编码查询平台人数
   */
  DubboResult<Integer> getPlatformUserCount(String code);

  /**
   * 根据地区查询机构id
   */
  DubboResult<ArrayList<OrganizationResDTO>> getAllOrgId(String code, String orgName);
  DubboResult<ArrayList<OrganizationResDTO>> getAllOrgIdByLimit(String code, String orgName, Integer pageIndex, Integer pageSize);
  DubboResult<Integer> getAllOrgIdByLimitCount(String code, String orgName);

  /**
   * 根据机构查找机构人数
   */
  DubboResult<Integer> getOrgUserCountByOrgId(Long orgId);
  /**
   * 根据机构查找机构(书记员、审判员、法官助理、陪审员)人数
   */
  DubboResult<ArrayList<UserOrgDetailsResDTO>> getOrgUserByOrgIdAndType(Long orgId, String keyWord, Integer pageIndex, Integer pageSize);
  DubboResult<Integer> getOrgUserByOrgIdAndTypeCount(Long orgId, String keyWord);
  /**
   * 根据地区查询机构总数
   */
  DubboResult<Integer> getOrgCountByAreaCode(String  areaCode);
  DubboResult<ArrayList<Long>> getOrgIdByAreaCode(String  areaCode);

}
