package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.odr.user.api.dto.UserInfoDTO;
import com.beiming.odr.user.api.dto.requestdto.ThirdJumpLoginReqDTO;
import com.beiming.odr.user.api.dto.responsedto.LoginInfoResDTO;
import java.util.ArrayList;
import javax.validation.Valid;
@Valid
public interface UserServiceThirdApi {

  
  DubboResult<LoginInfoResDTO> thirdJumpLogin(ThirdJumpLoginReqDTO dto);
  
  /**
   * 通过手机号码查找用户，没有找到，则注册用户
   * 
   * @see 针对的是普通用户,返回也只返回用户的基础信息 同时也要返回用户的登录信息
   * @param mobilePhone 手机号码
   * @param userName 用户姓名
   */
  DubboResult<UserInfoDTO> searchAndRegisterByMobileStaff(String mobilePhone, String userName);

  /**
   * 根据用户id查询用户邮箱
   */
  DubboResult<String> findEmailByUserId(Long userId);

  /**
   * 根据用户id和会议id查询用户邮箱
   */
  DubboResult<String> findEmailByUserIdAndMeetingId(Long userId, String objectId);
  
  DubboResult updateUserName(Long userId, String userName);

  /**
   * 根据省code获取该省的法院code数组
   * @param provinceCode
   * @return
   */
  DubboResult<ArrayList<String>> getOrgCodesByProCode(String provinceCode);


  DubboResult<String> checkIsFirstLogin(String mobilePhone);

  DubboResult<Long> searchUserInfoByPhone(String mobilePhone);

  /**
   * 通过手机号码查找用户，没有找到，则注册用户,绑定对应角色名称
   *
   * @param personType 用户账号类型
   * @param mobilePhone 手机号码
   * @param userName 用户姓名
   * @param registerOrigin 注册平台
   */
  DubboResult thirdRegisterByMobile(String personType, String mobilePhone, String userName,
      String registerOrigin, String organizationId, String organizationName);

}
