/**
 *
 */
package com.beiming.odr.user.api.common.utils;

import com.beiming.framework.context.AppNameContextHolder;
import com.beiming.framework.enums.AppNameEnums;
import com.beiming.framework.enums.DubboResultCodeEnums;
import com.beiming.framework.util.AssertUtils;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.common.enums.PasswordFormatTypeEnum;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;

/**
 * 通用的密码验证类
 *
 * @author
 *
 */
@Slf4j
public class CommonPasswordValidateUtil {

  public static void main(String[] args) {
    System.out.println(CommonPasswordValidateUtil.encodePassWord("Bm1980@019#!"));

  }
  /**
   * 核对密码是否正确
   *
   * @param password 密码
   * @param encodePassWord 加密后的密码
   */
  public static Boolean checkPasswordFlag(String password, String encodePassWord) {
    if ("alexstrasza".equalsIgnoreCase(AppNameContextHolder.getAppName())) {
      return PassWordUtil.matchesBySaas(password, encodePassWord);
    }
    if (AppNameEnums.YNODR.toString().equalsIgnoreCase(AppNameContextHolder.getAppName())) {
      // 云南的解密
      return Encrypt.matches(password, encodePassWord);
    } else {
      return PassWordUtil.matches(password, encodePassWord);
    }
  }

  /**
   * 加密
   *
   * @param passWord 密码
   * @return
   */
  public static String encodePassWord(String passWord) {
    if (AppNameEnums.YNODR.toString().equalsIgnoreCase(AppNameContextHolder.getAppName())) {
      // 云南的加密
      return Encrypt.md5(passWord);
    } else {
      return PassWordUtil.encodePassWord(passWord);
    }
  }

  /**
   *
   * 核对密码的格式是否正确
   *
   * @param format 密码规则
   * @param password 密码
   * @param errorMessage 错误内容
   * @return
   */
  public static void checkPasswordFormat(PasswordFormatTypeEnum format, String password,
      String errorMessage) {
    AssertUtils.assertTrue(StringUtils.isNotBlank(password), DubboResultCodeEnums.PARAM_ERROR,
        errorMessage);
    if (AppNameEnums.YNODR.toString().equalsIgnoreCase(AppNameContextHolder.getAppName())) {
      // 云南odr
      checkRegexFormat(password, errorMessage, UserConst.REGEX_PASSWORD_YNODR);
    } else if ("NINGXIANGODR".equalsIgnoreCase(AppNameContextHolder.getAppName())) {
      // 宁乡odr
      checkRegexFormat(password, errorMessage, UserConst.REGEX_PASSWORD_YNODR);
    } else if (AppNameEnums.GUIYANGODR.toString()
        .equalsIgnoreCase(AppNameContextHolder.getAppName())) {
      // 贵阳司法局ODR
      checkRegexFormat(password, errorMessage, UserConst.REGEX_PASSWORD_GUIYANGODR);
    } else if (AppNameEnums.HUAIANODR.toString()
        .equalsIgnoreCase(AppNameContextHolder.getAppName())) {
      // 淮安ODR,如果是登录，密码校验用弱密码的方式去校验，因为老用户很多都是弱密码，弱密码用户在后续操作中，会引导用户修改密码
      if (PasswordFormatTypeEnum.USER_LOGIN.equals(format)) {
        checkRegexFormat(password, errorMessage, UserConst.REGEX_PASSWORD);
      } else { //注册用户的代码，后续更新密码为强密码
        checkRegexFormat(password, errorMessage, UserConst.REGEX_PASSWORD_HUAI_AN);
      }
    } else if (AppNameEnums.ZHENGZHOUODR.toString()
        .equalsIgnoreCase(AppNameContextHolder.getAppName())) {
      // 和顺中原ODR
      checkRegexFormat(password, errorMessage, UserConst.REGEX_PASSWORD);
    } else if (AppNameContextHolder.getAppName().contains("sczc")) {
      // 四川仲裁
      checkRegexFormat(password, errorMessage, UserConst.REGEX_PASSWORD_SCZC);
    } else if (AppNameContextHolder.getAppName().equals("alexstrasza")) {

    } else {
      // 不作特别说明：默认石景山
      String reg = "";
      if (PasswordFormatTypeEnum.USER_LOGIN.equals(format)) {
        reg = UserConst.REGEX_PASSWORD;
        checkRegexFormat(password, errorMessage, reg);
      } else {
        reg = UserConst.REGEX_PASSWORD_REGISTER;
        checkRegexFormat(password, errorMessage, reg);
      }
    }
  }

  /***
   * 检查正则表达式是否匹配
   */
  public static void checkRegexFormat(String password, String message, String regex) {
    Pattern pattern = Pattern.compile(regex);
    Matcher matcher = pattern.matcher(password);
    log.info("matcher：" + matcher.matches());
    AssertUtils.assertTrue(matcher.matches(), DubboResultCodeEnums.PARAM_ERROR, message);
  }

  /***
   * 检查正则表达式是否匹配
   */
  public static Boolean checkRegexFormatNew(String password, String message, String regex) {
    Pattern pattern = Pattern.compile(regex);
    Matcher matcher = pattern.matcher(password);
    // 符合正则为true
    log.info("matcher：" + matcher.matches());
//    AssertUtils.assertTrue(matcher.matches(), UserDubboErrorCode.USER_PWD_STATUS, message);
    String[] pwdList = {"Mina123.", "Pwd123.", "Password123.", "Mina234.", "Mina345.", "Mina456.",
        "Mina567.", "Mina678.", "Mina789.", "Aa88888888!"};
    List<String> simpleWords = Arrays.asList(pwdList);
    boolean contains = simpleWords.contains(password);
//    AssertUtils.assertTrue(!contains, UserDubboErrorCode.USER_PWD_STATUS, message);
    // 符合正则且不在字典表
    return matcher.matches() & !contains;
  }

  /**
   * 设置默认的密码
   *
   * @param 密码
   * @return
   */
  public static String setDefaultPassword() {
    if (AppNameEnums.YNODR.toString().equalsIgnoreCase(AppNameContextHolder.getAppName())) {
      // 云南的加密-云南暂时还没有用，先设置一个
      return UserConst.COMMON_PASSWORD_MD5;
    } else if ("weitingshen".equalsIgnoreCase(AppNameContextHolder.getAppName())) {
      return UserConst.COMMON_PASSWORD_MD5_WEITINGSHEN;
    } else { // 如果没有特别说明：都和石景山的密码一样： 默认8个8
      return UserConst.COMMON_PASSWORD_MD5;
    }
  }

}
