package com.beiming.odr.user.api.dto.responsedto;

import com.beiming.framework.enums.CTypeEnums;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @Package: com.beiming.odr.user.api.dto.responsedto
 * @Title: UserLoginLogResDTO
 * @Description: TODO
 * @Author: Holger
 * @Date: 2025/9/18 11:12
 */
@Data
@EqualsAndHashCode(callSuper = false)
@NoArgsConstructor
@AllArgsConstructor
public class UserLoginLogResDTO implements Serializable {

  private static final long serialVersionUID = 1652466831393242066L;

  private Long id;

  private String userId;
  /**
   * 登录类型
   * @see CTypeEnums
   */
  private String clientType;
  /**
   * 登出时间
   */
  private Date logoutTime;
  /**
   * 在线时长
   */
  private Long onlineDuration;

  /**
   * 密评mac生成值
   */
  private String mac;

  /**
   * 密码iv生成值
   */
  private String iv;

}
