package com.beiming.odr.user.api;

import javax.validation.Valid;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.dto.requestdto.newsinformation.AddReqDTO;
import com.beiming.odr.user.api.dto.requestdto.newsinformation.ListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.newsinformation.SearchReqDTO;
import com.beiming.odr.user.api.dto.requestdto.newsinformation.UpdatePublishStatusReqDTO;
import com.beiming.odr.user.api.dto.requestdto.newsinformation.UpdateReqDTO;
import com.beiming.odr.user.api.dto.requestdto.newsinformation.UpdateStatusReqDTO;
import com.beiming.odr.user.api.dto.responsedto.NewsInformationResDTO;

/**
 * 新闻
 * 
 * @author fanheshui
 */
@Valid
public interface NewsInformationServiceApi {
  /**
   * 添加新闻内容
   */
  DubboResult addData(@Valid AddReqDTO addReqDTO);

  /**
   * 修改新闻内容
   */
  DubboResult updateData(@Valid UpdateReqDTO updateReqDTO);

  /**
   * 查询新闻内容-后端
   * @see 不需要查询上一页和下一页的数据
   */
  DubboResult<NewsInformationResDTO> searchData(@Valid SearchReqDTO searchReqDTO);
  
  /**
   * 查询新闻内容-前段
   * @see 需要查询上一页和下一页的数据
   */
  DubboResult<NewsInformationResDTO> frontSearchData(@Valid SearchReqDTO searchReqDTO);

  /**
   * 更新新闻发布状态
   */
  DubboResult updatePublishStatus(@Valid UpdatePublishStatusReqDTO updatePublishStatusReqDTO);

  /**
   * 新闻列表
   */
  DubboResult<PageInfo<NewsInformationResDTO>> listData(@Valid ListReqDTO listReqDTO);
  
  /**
   * 更新新闻发布状态
   */
  DubboResult updateStatus(@Valid UpdateStatusReqDTO updateStatusReqDTO);
}
