package com.beiming.odr.user.api.common.constants;

/**
 * Created by zli on 2018/5/3.
 *
 * 常量
 */
public class UserConst {
  /**
   * 数据库里默认的version值
   */
  public static final Integer DEFAULT_VERSION = 0;

  /**
   * 正则：手机号（精确）
   * <p>
   * 移动：134(0-8)、135、136、137、138、139、147、150、151、152、157、158、159、178、182、183、184、187、188、198
   * </p>
   * <p>
   * 联通：130、131、132、145、155、156、175、176、185、186、166
   * </p>
   * <p>
   * 电信：133、153、173、177、180、181、189、199
   * </p>
   * <p>
   * 全球星：1349
   * </p>
   * <p>
   * 虚拟运营商：170
   * </p>
   * @see 产品要求 手机号码格式修改为 1[3-9] 的手机号码格式
   */
  public static final String REGEX_MOBILE_EXACT = "^1[3-9]\\d{9}$";
      //"^((13[0-9])|(14[5,7])|(15[0-3,5-9])|(17[0,3,5-8])|(18[0-9])|166|198|199|(147))\\d{8}$";
  /**
   * 正则： 身份证格式是否正确
   */
  public static final String REGEX_ID_CARD =
      "^\\d{6}(18|19|20)?\\d{2}(0[1-9]|1[012])(0[1-9]|[12]\\d|3[01])\\d{3}(\\d|[xX])$";
  /**
   * 
   * 正则表达式: 验证密码的格式- 登录
   */
  public static final String REGEX_PASSWORD = "^[0-9a-zA-Z\\W]{8,16}$";
  /**
   *
   * 正则表达式: 验证强密码的格式
   */
  public static final String REGEX_STRONG_PASSWORD = "^(?=.*[a-z])(?=.*[A-Z])(?=.*\\d)(?=.*[$\\S])[A-Za-z\\d$\\S]{8,20}";
  /**
   * 淮安正则表达式强密码
   */
  public static final String REGEX_PASSWORD_HUAI_AN = "^(?![A-Za-z0-9]+$)(?![a-z0-9-_~!@#$%=^&*()+\\`.]+$)(?![A-Za-z-_~!@#$%=^&*()+\\`.]+$)(?![A-Z0-9-_~!@#$%=^&*()+\\`.]+$)[a-zA-Z0-9-_~!@#$%=^&*()+'\\`'.]{8,16}$";
  /**
   * 
   * 正则表达式: 验证密码的格式- 注册
   */
  //public static final String REGEX_PASSWORD_REGISTER = "^(?!^\\d+$)(?!^[a-zA-Z\\W]+$)(?!^[0-9a-z\\W]+$)(?!^[0-9A-Z\\W]+$)[0-9a-zA-Z\\W]{8,16}$";
  /**
   * 
   * 正则表达式: 验证密码的格式- 登录-加强密码
   */
  //public static final String REGEX_PASSWORD = "^[0-9a-zA-Z\\W]{8,16}$";
  
  // public static final String REGEX_PASSWORD_REGISTER = "^(?![A-Za-z0-9]+$)(?![a-z0-9\\W]+$)(?![A-Za-z\\W]+$)(?![A-Z0-9\\W]+$)[a-zA-Z0-9\\W]{8,12}$";
  public static final String REGEX_PASSWORD_REGISTER = "^(?![a-zA-Z]+$)(?![A-Z0-9]+$)(?![A-Z\\W_!@#$%^&*`~()-+=]+$)(?![a-z0-9]+$)(?![a-z\\W_!@#$%^&*`~()-+=]+$)(?![0-9\\W_!@#$%^&*`~()-+=]+$)(?![a-zA-Z0-9]+$)(?![a-zA-Z\\W_!@#$%^&*`~()-+=]+$)(?![a-z0-9\\W_!@#$%^&*`~()-+=]+$)(?![0-9A-Z\\W_!@#$%^&*`~()-+=]+$)[a-zA-Z0-9\\W_!@#$%^&*`~()-+=]{8,16}$";

  /**
   * @see 云南ODR
   * 正则表达式: 验证密码的格式
   */
  public static final String REGEX_PASSWORD_YNODR = "^.{6,}$";
  /**
   * 贵阳司法局ODR
   * 正则表达式: 验证密码的格式
   */
  public static final String REGEX_PASSWORD_GUIYANGODR = "^.{8,}$";

  /**
   * 四川仲裁修改密码，密码格式
   */
  public static final String REGEX_PASSWORD_SCZC = "^(?=.*[a-z])(?=.*[A-Z])(?=.*\\d)(?=.*[\\W_]).{8,16}$";

  /**
   * 默认密码
   */
  public static final String COMMON_PASSWORD = "88888888";
  
  public static final String COMMON_PASSWORD_ZC = "6bn2s00zK!";

  public static final String COMMON_PASSWORD_SCZC = "Aa88888888=";

//  public static final String COMMON_PASSWORD_WEITINGSHEN = "Aa88888888!";
  public static final String COMMON_PASSWORD_WEITINGSHEN = "Bm1980@019#!";

  /** 淮安默认密码 */
  public static final String COMMON_PASSWORD_HUAIAN = "!Ha9132022@odr";

  /**
   * 宁乡默认密码
   */
  public static final String NX_COMMON_PASSWORD = "123456";
  
  /**
   * 默认密码-peace项目的默认密码
   */
  public static final String COMMON_PASSWORD_PEACE = "admin12345";
  /**
   * 默认密码-md5加密的结果
   */
  public static final String COMMON_PASSWORD_MD5 = "37ad58268d3785e0f661da610c45ef0c";
  /**
   * 默认密码-md5加密的结果
   */
  public static final String COMMON_PASSWORD_MD5_WEITINGSHEN = "867249dabcd8391999b908a152ddcfb6";

  /**
   * 禁用状态
   */
  public static final String DISABLE_STATUS_VALUE = "1";

  /**
   * 邮箱的格式
   */
  public static final String REGEX_EMAIL =
      "^[a-zA-Z0-9_.-]+@[a-zA-Z0-9-]+(\\.[a-zA-Z0-9-]+)*\\.[a-zA-Z0-9]{2,6}$";
  
  /**
   * 市辖区名称常量
   */
  public static final String MUNICIPAL_DISTRICT = "市辖区";
  
  /**
   * 查询条件为手机号码
   */
  public static final String SEARCH_MOBILE_PHONE = "mobilePhone";

  /**
   * 查询条件为登录名
   */
  public static final String SEARCH_LOGIN_NAME = "loginName";
  
  /**
   * 内部测试用户和机构的备注
   */
  public static final String INTERNAL_TEST_REMARK = "INTERNAL_TEST_REMARK";
  /**
   * 石景山区地区代码
   */
  public static final String AREA_CODE_SHIJINGSHAN = "110107000000";
  
  /**
   * 信访代理人特别纠纷类型前缀
   */
  public static final String DISPUTE_TYPE_PETITION_PREFIX = "PETITION_";
  /**
   * 金融解纷纠纷类型前缀
   */
  public static final String DISPUTE_TYPE_FINANCIAL_PREFIX = "FINANCIAL_";
  /**
   * YYYYMMDD格式的字符串
   */
  public static final String REGEX_YYYYMMDD_DATE = "^((\\\\d{2}(([02468][048])|([13579][26]))[\\\\-\\\\/\\\\s]?((((0?[13578])|(1[02]))[\\\\-\\\\/\\\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\\\-\\\\/\\\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\\\-\\\\/\\\\s]?((0?[1-9])|([1-2][0-9])))))|(\\\\d{2}(([02468][1235679])|([13579][01345789]))[\\\\-\\\\/\\\\s]?((((0?[13578])|(1[02]))[\\\\-\\\\/\\\\s]?((0?[1-9])|([1-2][0-9])|(3[01])))|(((0?[469])|(11))[\\\\-\\\\/\\\\s]?((0?[1-9])|([1-2][0-9])|(30)))|(0?2[\\\\-\\\\/\\\\s]?((0?[1-9])|(1[0-9])|(2[0-8]))))))?$";
  /**验证数字*/
  public static final String REGEX_NUMBER_DATA = "^\\d+$";
  
 /**
   * 选择所有
   */
  public static final String SELECT_ALL_CODE = "ALL";
  
  /**
   * 新用户标识
   */
  public static final String NEW_USER = "NEW_USER";

  /**
   * 默认密码的字典key
   */
  public static final String PASSWORD_DEFAULT_VALUE = "defaultPassword";

  /**
   * 字典纠纷类型父级编码
   */
  public static final String DIC_DISPUTE_TYPE = "DISPUTE_TYPE";
}
