package com.beiming.odr.user.api.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.common.enums.PersonTypeEnum;
import lombok.Data;

/**
 * 重置密码
 */
@Data
public class CommonUserResetPasswordReqDTO implements Serializable {

  /**
   * 手机号
   */
  @Pattern(regexp = UserConst.REGEX_MOBILE_EXACT, message = "手机号码格式不对")
  @NotBlank(message = "手机号码不能为空")
  private String mobilePhone;

  /**
   * 密码
   */
  private String password;

  @NotNull(message = "工作人员类型不能为空")
  private PersonTypeEnum personTypeEnum;
}
