package com.beiming.odr.user.api.dto.requestdto;

import java.io.Serializable;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * @author chen
 * @date 2024/01/16
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class UserRoleDepartRelation implements Serializable {

  private static final long serialVersionUID = -228742763043718860L;

  /**
   * 用户角色id
   */
  private Long userRoleRelationId;
  /**
   * 用户id
   */
  private Long userId;

  /**
   * 角色id
   */
  private String roleCode;

  /**
   * 机构id
   */
  private Long organizationId;

  /**
   * 机构name
   */
  private String organizationName;

  /**
   * 所属地区代码
   */
  private String areaCode;

  /**
   * 所属地区代码名称
   */
  private String areaFullName;

  /**
   * 部门id
   */
  private Long departId;

  /**
   * 部门名称
   */
  private String departName;
}
