package com.beiming.odr.user.api;

import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.common.enums.RoleTypeEnum;
import com.beiming.odr.user.api.dto.UserInfoDTO;
import com.beiming.odr.user.api.dto.requestdto.OrganizationListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.RecommendOrganizationReqDTO;
import com.beiming.odr.user.api.dto.requestdto.SelOrgInfoSingleReqDTO;
import com.beiming.odr.user.api.dto.responsedto.HomeDataCountResDTO;
import com.beiming.odr.user.api.dto.responsedto.OrgInfoSingleResDTO;
import com.beiming.odr.user.api.dto.responsedto.OrgListOrderByMediatorNumberResDTO;
import com.beiming.odr.user.api.dto.responsedto.OrganizationResDTO;
import com.beiming.odr.user.api.dto.responsedto.ServicePersonNumberResDTO;


public interface OrganizationServiceApi {

  /**
   * 智能推荐调解机构
   *
   * @param recommendOrganizationReqDTO
   * @return
   */
  public DubboResult<OrganizationResDTO> getRecommendOrganization(
      RecommendOrganizationReqDTO recommendOrganizationReqDTO);

  /**
   * 选择调解机构列表分页
   *
   * @param organizationListReqDTO
   * @return
   */
  public DubboResult<PageInfo<OrganizationResDTO>> getMediateOrganizationListPage(
      OrganizationListReqDTO organizationListReqDTO);

  /**
   * 获取机构列表分页
   *
   * @param organizationListReqDTO
   * @return
   */
  public DubboResult<PageInfo<OrganizationResDTO>> getOrganizationListPage(
      OrganizationListReqDTO organizationListReqDTO);

  /**
   * 获取机构列表分页(淮安)
   *
   * @param organizationListReqDTO
   * @return
   */
  public DubboResult<PageInfo<OrganizationResDTO>> getOrganizationListPageH(
      OrganizationListReqDTO organizationListReqDTO);

  /**
   * 推荐机构列表根据调解员数量倒序 limit 5
   *
   * @param currentUserId
   * @return
   */
  public DubboResult<ArrayList<OrgListOrderByMediatorNumberResDTO>> getOrgListOrderByMediatorNumber(
      String disputeTypeCode, String currentUserId);

  /**
   * 获取机构详情
   *
   * @param orgId
   * @return
   */
  public DubboResult<OrganizationResDTO> getOrganizationDetail(Long orgId);

  /**
   * 查询机构下服务人员的数量
   *
   * @param orgId
   * @return
   */
  public DubboResult<ServicePersonNumberResDTO> getServicePersonNumber(List<Long> orgIds);

  /**
   * 查询机构下服务人员的数量
   *
   * @param orgId
   * @return
   */
  public DubboResult<ServicePersonNumberResDTO> getServicePersonNumber(List<Long> orgIds,
      String currentUserId);

  /**
   * 查询首页统计数据
   *
   * @return
   */
  public DubboResult<HomeDataCountResDTO> getHomeDataCount();

  /**
   * 查询机构总数量
   *
   * @return
   */
  public DubboResult<Integer> getAllOrganizationCount();

  /**
   * 得到机构管理员所在的机构id
   */
  DubboResult<Long> getOrgIdByOrgManageUser(Long userId);

  /**
   * 通过机构管理员或区域管理员id获取所在区域
   *
   * @param userId
   * @return
   */
  public DubboResult<String> getAreaCodeByManageUserId(Long userId);

  /**
   * 根据区域代码查询区域下面的所有简易机构信息
   *
   * @param arg0
   * @return
   */
  public DubboResult<ArrayList<OrgInfoSingleResDTO>> getOrgSingleInfoList(
      @Valid SelOrgInfoSingleReqDTO arg0);

  /**
   * <pre>
   * 传入调解员或机构管理员的userId查询其绑定的所以机构的简易信息
   * @param arg0
   * @return
   */
  public DubboResult<ArrayList<OrgInfoSingleResDTO>> getOrgSingleInfoByUserId(String userId);

  /**
   * 根据机构id和要查询的角色类型，返回对应的角色类型的用户详情
   *
   * @param orgId            机构id
   * @param roleTypeEnumList 角色类型列表
   */
  public DubboResult<ArrayList<UserInfoDTO>> getUserInfoByOrgIdAndRoleType(Long orgId,
      List<RoleTypeEnum> roleTypeEnumList);

  /**
   * 查询用户所在机构，本级及父级
   *
   * @param userId
   * @return
   */
  public DubboResult<ArrayList<OrganizationResDTO>> getOrganizationListByUserId(Long userId);

  /**
   * 查询用户所在机构，本级及以下子级
   *
   * @param userId
   * @return
   */
  public DubboResult<ArrayList<OrganizationResDTO>> getLowerOrganizationListByUserId(Long userId);

  DubboResult<OrganizationResDTO> getOrgInfoByFeiSuAreaCode(String orgAreaCode, String level);

  /**
   * 法院CODE来查询机构
   *
   * @param code
   * @return
   */
  DubboResult<OrganizationResDTO> getOrganizationDetailByCode(String code);

  /**
   * 根据id批量更改组织状态
   * @param status
   * @param ids
   * @return
   */
  Integer updateOrgStatus(Integer status, List ids);

  /**
   * 根据组织名字查询组织信息
   * @param orgName
   * @return
   */
  DubboResult<OrganizationResDTO> findOrgByName(String orgName);

}
