package com.beiming.odr.user.api;

import java.util.List;
import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.dto.requestdto.RoleAddReqDTO;
import com.beiming.odr.user.api.dto.requestdto.RoleDeleteReqDTO;
import com.beiming.odr.user.api.dto.requestdto.RoleListReqDTO;
import com.beiming.odr.user.api.dto.requestdto.RoleSearchByReqDTO;
import com.beiming.odr.user.api.dto.requestdto.RoleSearchReqDTO;
import com.beiming.odr.user.api.dto.requestdto.RoleUpdateReqDTO;
import com.beiming.odr.user.api.dto.responsedto.GetOrganizationsByRoleCodeResDTO;
import com.beiming.odr.user.api.dto.responsedto.RoleInfoResDTO;
import com.beiming.odr.user.api.dto.responsedto.RoleInfoResListDTO;

public interface RoleServiceApi {
  /**
   * 角色的新增
   */

  DubboResult insertRole(RoleAddReqDTO roleAddReqDTO);

  /**
   * 角色的修改
   */
  DubboResult updateRole(RoleUpdateReqDTO roleUpdateReqDTO);

  /**
   * 角色列表
   */
  DubboResult<PageInfo<RoleInfoResDTO>> listRole(RoleListReqDTO roleListReqDTO);

  /**
   * 获取角色信息
   */
  DubboResult<RoleInfoResDTO> getRoleCode(RoleSearchReqDTO roleSearchReqDTO);

  /**
   * 角色删除
   */
  DubboResult deleteRole(RoleDeleteReqDTO roleDeleteReqDTO);

  /**
   * 查询工作人员角色
   */
  DubboResult<RoleInfoResListDTO> searchWorkUserRole(RoleSearchReqDTO roleSearchReqDTO);

  /**
   * 查询人员角色
   */
  DubboResult<RoleInfoResListDTO> searchUserRole(RoleSearchByReqDTO roleSearchReqDTO);

  /***
   * 通过角色代码集合查询关联机构信息
   */
  public DubboResult<GetOrganizationsByRoleCodeResDTO> getOrganizationsByRoleCodes(
      List<String> roleCodes);

  /**
   * 禁用角色
   * @param roleDeleteReqDTO
   * @return
   */
  DubboResult<Boolean> disableRole(RoleDeleteReqDTO roleDeleteReqDTO);

  /**
   * 启用角色
   * @param roleDeleteReqDTO
   * @return
   */
  DubboResult<Boolean> enableRole(RoleDeleteReqDTO roleDeleteReqDTO);

  /**
   * 查询机构工作人员数
   *
   * @param orgId org id
   * @return {@link DubboResult}<{@link Integer}>
   */
  DubboResult<Integer> selectPersonCount(Long orgId);
}
