package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.common.enums.RoleTypeEnum;
import com.beiming.odr.user.api.dto.requestdto.AddServicePersonReqDTO;
import com.beiming.odr.user.api.dto.requestdto.SearchServicePersonInfoReqDTO;
import com.beiming.odr.user.api.dto.requestdto.SearchServicePersonReqByMobileDTO;
import com.beiming.odr.user.api.dto.requestdto.SearchServicePersonReqDTO;
import com.beiming.odr.user.api.dto.requestdto.ServicePersonUpdateRoleReqDTO;
import com.beiming.odr.user.api.dto.responsedto.SearchServicePersonInfoResDTO;
import com.beiming.odr.user.api.dto.responsedto.SearchServicePersonResDTO;
import com.beiming.odr.user.api.dto.responsedto.SerchServicePersonGrantAuthInfoResDTO;
import com.beiming.odr.user.api.dto.responsedto.ServicePersonListResDTO;
import java.util.ArrayList;
import javax.validation.Valid;

/**
 * 服务人员相关接口
 * 
 * @author
 */
@Valid
public interface ServicePersonServiceApi {



  /**
   * 机构管理员-添加服务人员
   */
  public DubboResult addServicePerson(AddServicePersonReqDTO addServicePersonReqDTO);

  /**
   * 查询服务人员详细信息
   */
  public DubboResult<SearchServicePersonResDTO> searchServicePerson(
      SearchServicePersonReqDTO searchServicePersonReqDTO);

  /**
   * 机构管理员-编辑服务人员
   */
  DubboResult updateServicePerson(AddServicePersonReqDTO addServicePersonReqDTO);

  /**
   * 查询服务人员授权信息
   */
  DubboResult<SerchServicePersonGrantAuthInfoResDTO> serchServicePersonGrantAuthInfo(Long userId);

  /**
   * 查询服务人员详细信息-通过手机号码
   */
  DubboResult<SearchServicePersonResDTO> searchServicePersonByMobile(
      SearchServicePersonReqByMobileDTO request);

  /**
   * 机构管理员-更新服务人员权限
   */
  DubboResult updateServicePersonRole(
      @Valid ServicePersonUpdateRoleReqDTO servicePersonUpdateRoleReqDTO);
  
  /**
   * 通过用户名称、角色类型查询服务人员分页
   * @param userName
   * @param roleType
   * @return
   */
  DubboResult<PageInfo<ServicePersonListResDTO>> getServicePersonByUserNameAndRoleType(String userName, RoleTypeEnum roleType);


  /**
   * 根据机构名字和调解员名字查询用户信息
   */
  DubboResult<ArrayList<SearchServicePersonInfoResDTO>> searchServicePersonInfo(SearchServicePersonInfoReqDTO searchServicePersonReqDTO);

}
