package com.beiming.odr.user.api;

import com.beiming.framework.domain.DubboResult;
import com.beiming.framework.page.PageInfo;
import com.beiming.odr.user.api.common.enums.StatusEnum;
import com.beiming.odr.user.api.common.enums.UserLoginTypeEnum;
import com.beiming.odr.user.api.dto.AppointUserAuthStatusDTO;
import com.beiming.odr.user.api.dto.QueryUserInfoDTO;
import com.beiming.odr.user.api.dto.UserInfoDTO;
import com.beiming.odr.user.api.dto.requestdto.AppointJudgeUserReqDTO;
import com.beiming.odr.user.api.dto.requestdto.CommonIdReqDTO;
import com.beiming.odr.user.api.dto.requestdto.CommonUserRegisterReqDTO;
import com.beiming.odr.user.api.dto.requestdto.CompanyUserInfoPageReqDTO;
import com.beiming.odr.user.api.dto.requestdto.CompanyUserRegisterReqDTO;
import com.beiming.odr.user.api.dto.requestdto.QueryUserInfoReqDTO;
import com.beiming.odr.user.api.dto.requestdto.RealNameAuthenticationReqDTO;
import com.beiming.odr.user.api.dto.requestdto.SearchRoleUserInfoReqDTO;
import com.beiming.odr.user.api.dto.requestdto.UserLoginAndRegisterReqDTO;
import com.beiming.odr.user.api.dto.requestdto.UserLoginByMicroCourtReqDTO;
import com.beiming.odr.user.api.dto.requestdto.UserLoginBySxMicroCourtReqDTO;
import com.beiming.odr.user.api.dto.responsedto.AppointJudgeResDTO;
import com.beiming.odr.user.api.dto.responsedto.AppointJudgeUserResDTO;
import com.beiming.odr.user.api.dto.responsedto.BatchUserRegisterResDTO;
import com.beiming.odr.user.api.dto.responsedto.CompanyUserInfoResDTO;
import com.beiming.odr.user.api.dto.responsedto.LoginInfoResDTO;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;


/***
 * @see 用户api中已经放不下了，特此新建第二个用户api
 */
@Valid
public interface UserServiceSecondApi {

  /**
   * 通过手机号码查找用户，没有找到，则注册用户
   * 
   * @see 针对的是普通用户,返回也只返回用户的基础信息 同时也要返回用户的登录信息
   * @param mobilePhone 手机号码
   * @param userName 用户姓名
   */
  DubboResult<UserInfoDTO> searchAndRegisterByMobileCommon(String mobilePhone, String userName);
  /**
   * 通过手机号码查找用户，没有找到，则注册用户
   *
   * @see 针对的是普通用户,返回也只返回用户的基础信息 同时也要返回用户的登录信息
   * @param mobilePhone 手机号码
   * @param userName 用户姓名
   */
  DubboResult<UserInfoDTO> searchAndRegisterByMobileCommonByTDHPushData(String mobilePhone,
      String userName, String roleName, String orgName, Long orgId, String meetingUserType);

  /**
   * 通过手机号码查找用户，没有找到，则注册用户
   * 如果用户名和库里面的不一致,则修改用户名为最新
   * @see 针对的是普通用户,返回也只返回用户的基础信息 同时也要返回用户的登录信息
   * @param mobilePhone 手机号码
   * @param userName 用户姓名
   * @param idCard 
   * @since 20200426
   */
  DubboResult<UserInfoDTO> searchAndRegisterAndUpdateNameByMobileCommon(String mobilePhone, String userName, String idCard);

  /**
   * 通过用户id查询用户信息
   * 
   * @param mobilePhone 手机号码
   */
  DubboResult<ArrayList<UserInfoDTO>> searchUserInfoByUserId(List<Long> list);

  /**
   * 查询角色用户信息
   * 
   * @param mobilePhone 手机号码
   */
  DubboResult<UserInfoDTO> searchRoleUserInfo(SearchRoleUserInfoReqDTO param);

  /** 实名认证和人脸识别一起设置 */
  DubboResult setRealNameAndFacialVerify(Long userId, RealNameAuthenticationReqDTO requestDTO);

  /**
   * 批量注册 用过手机号码列表
   * 
   * @see 不做数据的任何校验，就做简单的插入。数据校验，调用该接口时，自己校验
   * @param mobilePhone 手机号码
   */
  DubboResult<ArrayList<BatchUserRegisterResDTO>> batchUserRegister(List<String> list);
  
  /** 查询企业用户的信息 */
  DubboResult<CompanyUserInfoResDTO> searchCompanyUser(CommonIdReqDTO commonIdReqDTO);
  
  /** 查询企业用户分页 */
  DubboResult<PageInfo<CompanyUserInfoResDTO>> getCompanyUserInfoPage(CompanyUserInfoPageReqDTO companyUserInfoPageReqDTO);
  /** 审核企业用户 */
  DubboResult approveCompanyUser(Long userId, StatusEnum statusEnum);
  
  /**
   * 新增企业用户
   */
  DubboResult<LoginInfoResDTO> insertCompanyUser(@Valid CompanyUserRegisterReqDTO companyUserRegisterReqDTO);
  
  /**
   * 新增普通用户
   */
  DubboResult validateRegisterCompanyUser(@Valid CommonUserRegisterReqDTO commonUserRegisterReqDTO);
  
  /**
   * 是否是新用户
   * @param userId
   * @return true：新用户，false：老用户
   */
  public DubboResult<Boolean> isNewUser(Long userId);
  
  /**
   * 更新新用户为旧用户
   * @param userId
   * @return
   */
  public DubboResult updateNewUser(Long userId);

  public DubboResult updateMobilePhoneUserNameByUserId(String userName, String mobilePhone, Long userId);
 
  /** 用户登录-吉林微法院直接登录 */
  DubboResult<LoginInfoResDTO> userLoginByMicroCourt(UserLoginByMicroCourtReqDTO req);

  /** 用户登录-陕西微法院直接登录 */
  DubboResult<LoginInfoResDTO> userLoginBySxMicroCourt(UserLoginBySxMicroCourtReqDTO req);
  
  /** 用户登录并注册 */
  public DubboResult<LoginInfoResDTO> userLoginAndRegister(UserLoginAndRegisterReqDTO req);
  
  /**
   * 通过手机号码查找用户
   * @param mobilePhone 手机号码
   */
  DubboResult<ArrayList<UserInfoDTO>> searchUserByMobile(String mobilePhone);
  
  /**
   * 通过人员代码查询用户信息
   * 人员代码保存在用户表login_name字段
   * @param userCode 人员代码
   */
  DubboResult<UserInfoDTO> searchByUserCode(String userCode);

  /**
   * 通过手机号获取用户信息
   * @param mobile
   * @param loginType
   */
  DubboResult<LoginInfoResDTO> getUserLoginInfo(String mobile, UserLoginTypeEnum loginType);

  /**
   * 根据人员名字,类型查询
   * @param reqDTO
   * @return
   */
  DubboResult<ArrayList<QueryUserInfoDTO>> queryUserInfoByNameAndPersonType(QueryUserInfoReqDTO reqDTO);
  
  /**
   * 更具法院代碼查詢數據
   * @param code
   * @return
   */
  List<String> getCityCode(String code);

  //保存小程序实名后的名字和身份证
  //DubboResult setRealNameAuthentication(Long userId, RealNameAuthenticationReqDTO req);
  
  /**
   * 通过手机号获取工作人员信息
   * @param mobilePhone
   * @return
   */
  DubboResult<UserInfoDTO> getStaffUserId(String mobilePhone);
  
  /**
   * 通过用户id获取人员信息
   * @param userId
   * @return
   */
  DubboResult<UserInfoDTO> getUserInfoByUserId(Long userId);

  /**
   * 注册仲裁员和书记员（只传了姓名）
   * */
  DubboResult<ArrayList<BatchUserRegisterResDTO>> usersRegister(List<String> list);

  /**
   * 根据手机号查询身份证号
   * 
   * @param idCard
   * @return
   */
  DubboResult<ArrayList<String>> userIdCard(String idCard);

  /**
   * 通过身份证号和姓名查找用户，没有找到，则注册用户(访客预约系统)
   *
   * @param mobilePhone 手机号码
   * @param userName 用户姓名
   * @param userCard
   */
  DubboResult<UserInfoDTO> searchAndRegisterByMobileofVisitSystem(String mobilePhone, String userName, String userCard);

  /**
   * 访客预约系统 实名认证和人脸识别一起设置
   * @param userId
   * @param requestDTO
   * @return
   */
  DubboResult<UserInfoDTO> setVisitSystemRealNameAndFacialVerify(Long userId, RealNameAuthenticationReqDTO requestDTO);

  /**
   * 访客预约系统 验证是否超过两小时
   * @param requestDTO
   * @return
   */
  DubboResult<Boolean>  verifyExpiration(Long userId, RealNameAuthenticationReqDTO requestDTO);

  /**
   * 获取多个用户的认证状态
   * @param list
   * @return
   */
  DubboResult<ArrayList<AppointUserAuthStatusDTO>> setAuthStatus(List<Integer> list);

  /**
   * 访客预约系统 受访部门集合
   * @return
   */
  DubboResult<ArrayList<AppointJudgeResDTO>> departmentList();

  /**
   * 访客预约系统 某部门下所有法官
   * @param dto
   * @return
   */
  DubboResult<ArrayList<AppointJudgeUserResDTO>> judgeList(AppointJudgeUserReqDTO dto);
}
