package com.beiming.odr.user.api.common.enums;

import com.beiming.framework.domain.DubboResultCode;

/**
 * 业务人员类型枚举
 * @author fanheshui
 *
 */
public enum UserCustomResultCodeEnum implements DubboResultCode {
  NOTICE_DISPUTE_TYPE(90901, "通知_纠纷类型数据已经存在"),
  NOTICE_AREA_CODE(90902, "通知_区域数据已经存在"),
  ERROR(90903, "错误");

  private  int value;

  private  String desc;
  
  UserCustomResultCodeEnum(int value, String desc) {
    this.value = value;
    this.desc = desc;
  }
  
  @Override
  public int value() {
    return value;
  }

  @Override
  public String desc() {
    return desc;
  }

}
