package com.beiming.odr.user.api.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import lombok.Data;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.common.constants.ValidateMessage;

/**
 * 用户账号登录请求
 */
@Data
public class UserAccountLoginReqDTO implements Serializable {

  /**
   * 手机号
   */
  @NotBlank(message = ValidateMessage.NAME_NOT_BLANK)
  private String loginName;

  /**
   * 密码
   */
  @Pattern(regexp = UserConst.REGEX_PASSWORD, message = ValidateMessage.MOBILE_PHONE_INCORRECT)
  private String password;
}
