package com.beiming.odr.user.api.dto.requestdto;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Pattern;
import com.beiming.odr.user.api.common.constants.UserConst;
import com.beiming.odr.user.api.common.enums.PersonTypeEnum;
import com.beiming.odr.user.api.common.enums.RegisterOriginEnum;
import lombok.Data;

/**
 * 普通用户注册
 */
@Data
public class UserRegisterReqDTO implements Serializable {


  private static final long serialVersionUID = 1L;

  /**
   * 手机号
   */
  @NotBlank(message = "手机号码不能为空")
  @Pattern(regexp = UserConst.REGEX_MOBILE_EXACT, message = "手机号码格式不对")
  private String mobilePhone;

  /**
   * 密码
   */
  private String password;

  /**
   * 姓名
   */
  private String userName;


  /**
   * 人员类型
   */
  private PersonTypeEnum personType = PersonTypeEnum.COMMON;


  /**
   * 用户主被动标识
   * 
   * @see RegisterOriginEnum
   */
  private RegisterOriginEnum registerOrigin = RegisterOriginEnum.REGISTER_SELF;

  /**
   * 是否实名
   */
  private Boolean isRealName = false;

  /**
   * 是否完成人脸识别
   */
  private Boolean isFacialVerify = false;

  /**
   * 身份证
   */
  private String idCard;
}
