package com.beiming.odr.user.api.dto.responsedto;

import java.io.Serializable;
import javax.validation.constraints.NotBlank;
import com.beiming.odr.user.api.dto.UserAddressInfoDTO;
import lombok.Data;

/**
 * 普通用户查询接口
 */
@Data
public class CommonUserSearchResDTO implements Serializable {


  public CommonUserSearchResDTO() {

  }

  public CommonUserSearchResDTO(Long userId, String idCard, String userName, String sex,
      String birthday, UserAddressInfoDTO currentAddress, UserAddressInfoDTO permanentAddress,
      String portraitUrl, Boolean isRealName, Boolean isFacialVerify, String mobilePhone,
      String email, String businessPeopleType) {
    this.userId = userId;
    this.idCard = idCard;
    this.userName = userName;
    this.sex = sex;
    this.birthday = birthday;
    this.currentAddress = currentAddress;
    this.permanentAddress = permanentAddress;
    this.portraitUrl = portraitUrl;
    this.isRealName = isRealName == null ? false : isRealName;
    this.mobilePhone = mobilePhone;
    this.isFacialVerify = isFacialVerify  == null ? false : isFacialVerify;
    this.email = email;
    this.businessPeopleType = businessPeopleType;
  }

  /**
   * 邮箱
   */
  private String email;
  /**
   * userId
   */
  private Long userId;

  /**
   * 手机号
   */
  private String mobilePhone;
  /**
   * 身份证
   */
  private String idCard;

  /**
   * 用户姓名
   */
  private String userName;

  /**
   * 用户是否实名
   */
  private Boolean isRealName;
  /**
   * 是否人脸识别
   */
  private Boolean isFacialVerify;

  /**
   * 性别
   */
  @NotBlank(message = "性别不能为空")
  private String sex;

  /**
   * 生日
   */
  private String birthday;


  /*
   * [{provinceCode：, provinceName：, cityCode：, cityName：, areaCode：, areaName：, streetCode：,
   * streetName：, communitCode：, communityName：, detailedAddress：},{....}]
   */
  /** 当前居住地址 */
  private UserAddressInfoDTO currentAddress;
  /** 户籍地址 */
  private UserAddressInfoDTO permanentAddress;
  /** 头像 */
  private String portraitUrl;
  
  /**
   * 业务人员类型
   * */
  private String businessPeopleType;
  /**
   * 人员类型
   * */
  private String personType;


}
